<?php
// This file was auto-generated from sdk-root/src/data/medialive/2017-10-14/api-2.json
return [ 'metadata' => [ 'apiVersion' => '2017-10-14', 'endpointPrefix' => 'medialive', 'signingName' => 'medialive', 'serviceFullName' => 'AWS Elemental MediaLive', 'serviceId' => 'MediaLive', 'protocol' => 'rest-json', 'jsonVersion' => '1.1', 'uid' => 'medialive-2017-10-14', 'signatureVersion' => 'v4', 'serviceAbbreviation' => 'MediaLive', ], 'operations' => [ 'CreateChannel' => [ 'name' => 'CreateChannel', 'http' => [ 'method' => 'POST', 'requestUri' => '/prod/channels', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateChannelRequest', ], 'output' => [ 'shape' => 'CreateChannelResponse', ], 'errors' => [ [ 'shape' => 'UnprocessableEntityException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'GatewayTimeoutException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], ], ], 'CreateInput' => [ 'name' => 'CreateInput', 'http' => [ 'method' => 'POST', 'requestUri' => '/prod/inputs', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateInputRequest', ], 'output' => [ 'shape' => 'CreateInputResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'GatewayTimeoutException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'CreateInputSecurityGroup' => [ 'name' => 'CreateInputSecurityGroup', 'http' => [ 'method' => 'POST', 'requestUri' => '/prod/inputSecurityGroups', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateInputSecurityGroupRequest', ], 'output' => [ 'shape' => 'CreateInputSecurityGroupResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'GatewayTimeoutException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DeleteChannel' => [ 'name' => 'DeleteChannel', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/prod/channels/{channelId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteChannelRequest', ], 'output' => [ 'shape' => 'DeleteChannelResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'GatewayTimeoutException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], ], ], 'DeleteInput' => [ 'name' => 'DeleteInput', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/prod/inputs/{inputId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteInputRequest', ], 'output' => [ 'shape' => 'DeleteInputResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'GatewayTimeoutException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], ], ], 'DeleteInputSecurityGroup' => [ 'name' => 'DeleteInputSecurityGroup', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/prod/inputSecurityGroups/{inputSecurityGroupId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteInputSecurityGroupRequest', ], 'output' => [ 'shape' => 'DeleteInputSecurityGroupResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'GatewayTimeoutException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DescribeChannel' => [ 'name' => 'DescribeChannel', 'http' => [ 'method' => 'GET', 'requestUri' => '/prod/channels/{channelId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeChannelRequest', ], 'output' => [ 'shape' => 'DescribeChannelResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'GatewayTimeoutException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DescribeInput' => [ 'name' => 'DescribeInput', 'http' => [ 'method' => 'GET', 'requestUri' => '/prod/inputs/{inputId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeInputRequest', ], 'output' => [ 'shape' => 'DescribeInputResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'GatewayTimeoutException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DescribeInputSecurityGroup' => [ 'name' => 'DescribeInputSecurityGroup', 'http' => [ 'method' => 'GET', 'requestUri' => '/prod/inputSecurityGroups/{inputSecurityGroupId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeInputSecurityGroupRequest', ], 'output' => [ 'shape' => 'DescribeInputSecurityGroupResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'GatewayTimeoutException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListChannels' => [ 'name' => 'ListChannels', 'http' => [ 'method' => 'GET', 'requestUri' => '/prod/channels', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListChannelsRequest', ], 'output' => [ 'shape' => 'ListChannelsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'GatewayTimeoutException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListInputSecurityGroups' => [ 'name' => 'ListInputSecurityGroups', 'http' => [ 'method' => 'GET', 'requestUri' => '/prod/inputSecurityGroups', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListInputSecurityGroupsRequest', ], 'output' => [ 'shape' => 'ListInputSecurityGroupsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'GatewayTimeoutException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListInputs' => [ 'name' => 'ListInputs', 'http' => [ 'method' => 'GET', 'requestUri' => '/prod/inputs', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListInputsRequest', ], 'output' => [ 'shape' => 'ListInputsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'GatewayTimeoutException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'StartChannel' => [ 'name' => 'StartChannel', 'http' => [ 'method' => 'POST', 'requestUri' => '/prod/channels/{channelId}/start', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StartChannelRequest', ], 'output' => [ 'shape' => 'StartChannelResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'GatewayTimeoutException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], ], ], 'StopChannel' => [ 'name' => 'StopChannel', 'http' => [ 'method' => 'POST', 'requestUri' => '/prod/channels/{channelId}/stop', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StopChannelRequest', ], 'output' => [ 'shape' => 'StopChannelResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'BadGatewayException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'GatewayTimeoutException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'ConflictException', ], ], ], ], 'shapes' => [ 'AacCodingMode' => [ 'type' => 'string', 'enum' => [ 'AD_RECEIVER_MIX', 'CODING_MODE_1_0', 'CODING_MODE_1_1', 'CODING_MODE_2_0', 'CODING_MODE_5_1', ], ], 'AacInputType' => [ 'type' => 'string', 'enum' => [ 'BROADCASTER_MIXED_AD', 'NORMAL', ], ], 'AacProfile' => [ 'type' => 'string', 'enum' => [ 'HEV1', 'HEV2', 'LC', ], ], 'AacRateControlMode' => [ 'type' => 'string', 'enum' => [ 'CBR', 'VBR', ], ], 'AacRawFormat' => [ 'type' => 'string', 'enum' => [ 'LATM_LOAS', 'NONE', ], ], 'AacSettings' => [ 'type' => 'structure', 'members' => [ 'Bitrate' => [ 'shape' => '__double', 'locationName' => 'bitrate', ], 'CodingMode' => [ 'shape' => 'AacCodingMode', 'locationName' => 'codingMode', ], 'InputType' => [ 'shape' => 'AacInputType', 'locationName' => 'inputType', ], 'Profile' => [ 'shape' => 'AacProfile', 'locationName' => 'profile', ], 'RateControlMode' => [ 'shape' => 'AacRateControlMode', 'locationName' => 'rateControlMode', ], 'RawFormat' => [ 'shape' => 'AacRawFormat', 'locationName' => 'rawFormat', ], 'SampleRate' => [ 'shape' => '__double', 'locationName' => 'sampleRate', ], 'Spec' => [ 'shape' => 'AacSpec', 'locationName' => 'spec', ], 'VbrQuality' => [ 'shape' => 'AacVbrQuality', 'locationName' => 'vbrQuality', ], ], ], 'AacSpec' => [ 'type' => 'string', 'enum' => [ 'MPEG2', 'MPEG4', ], ], 'AacVbrQuality' => [ 'type' => 'string', 'enum' => [ 'HIGH', 'LOW', 'MEDIUM_HIGH', 'MEDIUM_LOW', ], ], 'Ac3BitstreamMode' => [ 'type' => 'string', 'enum' => [ 'COMMENTARY', 'COMPLETE_MAIN', 'DIALOGUE', 'EMERGENCY', 'HEARING_IMPAIRED', 'MUSIC_AND_EFFECTS', 'VISUALLY_IMPAIRED', 'VOICE_OVER', ], ], 'Ac3CodingMode' => [ 'type' => 'string', 'enum' => [ 'CODING_MODE_1_0', 'CODING_MODE_1_1', 'CODING_MODE_2_0', 'CODING_MODE_3_2_LFE', ], ], 'Ac3DrcProfile' => [ 'type' => 'string', 'enum' => [ 'FILM_STANDARD', 'NONE', ], ], 'Ac3LfeFilter' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', ], ], 'Ac3MetadataControl' => [ 'type' => 'string', 'enum' => [ 'FOLLOW_INPUT', 'USE_CONFIGURED', ], ], 'Ac3Settings' => [ 'type' => 'structure', 'members' => [ 'Bitrate' => [ 'shape' => '__double', 'locationName' => 'bitrate', ], 'BitstreamMode' => [ 'shape' => 'Ac3BitstreamMode', 'locationName' => 'bitstreamMode', ], 'CodingMode' => [ 'shape' => 'Ac3CodingMode', 'locationName' => 'codingMode', ], 'Dialnorm' => [ 'shape' => '__integer', 'locationName' => 'dialnorm', ], 'DrcProfile' => [ 'shape' => 'Ac3DrcProfile', 'locationName' => 'drcProfile', ], 'LfeFilter' => [ 'shape' => 'Ac3LfeFilter', 'locationName' => 'lfeFilter', ], 'MetadataControl' => [ 'shape' => 'Ac3MetadataControl', 'locationName' => 'metadataControl', ], ], ], 'AccessDenied' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => '__string', 'locationName' => 'message', ], ], ], 'AfdSignaling' => [ 'type' => 'string', 'enum' => [ 'AUTO', 'FIXED', 'NONE', ], ], 'ArchiveContainerSettings' => [ 'type' => 'structure', 'members' => [ 'M2tsSettings' => [ 'shape' => 'M2tsSettings', 'locationName' => 'm2tsSettings', ], ], ], 'ArchiveGroupSettings' => [ 'type' => 'structure', 'members' => [ 'Destination' => [ 'shape' => 'OutputLocationRef', 'locationName' => 'destination', ], 'RolloverInterval' => [ 'shape' => '__integer', 'locationName' => 'rolloverInterval', ], ], ], 'ArchiveOutputSettings' => [ 'type' => 'structure', 'members' => [ 'ContainerSettings' => [ 'shape' => 'ArchiveContainerSettings', 'locationName' => 'containerSettings', ], 'Extension' => [ 'shape' => '__string', 'locationName' => 'extension', ], 'NameModifier' => [ 'shape' => '__string', 'locationName' => 'nameModifier', ], ], ], 'AribDestinationSettings' => [ 'type' => 'structure', 'members' => [], ], 'AribSourceSettings' => [ 'type' => 'structure', 'members' => [], ], 'AudioChannelMapping' => [ 'type' => 'structure', 'members' => [ 'InputChannelLevels' => [ 'shape' => 'ListOfInputChannelLevel', 'locationName' => 'inputChannelLevels', ], 'OutputChannel' => [ 'shape' => '__integer', 'locationName' => 'outputChannel', ], ], ], 'AudioCodecSettings' => [ 'type' => 'structure', 'members' => [ 'AacSettings' => [ 'shape' => 'AacSettings', 'locationName' => 'aacSettings', ], 'Ac3Settings' => [ 'shape' => 'Ac3Settings', 'locationName' => 'ac3Settings', ], 'Eac3Settings' => [ 'shape' => 'Eac3Settings', 'locationName' => 'eac3Settings', ], 'Mp2Settings' => [ 'shape' => 'Mp2Settings', 'locationName' => 'mp2Settings', ], 'PassThroughSettings' => [ 'shape' => 'PassThroughSettings', 'locationName' => 'passThroughSettings', ], ], ], 'AudioDescription' => [ 'type' => 'structure', 'members' => [ 'AudioNormalizationSettings' => [ 'shape' => 'AudioNormalizationSettings', 'locationName' => 'audioNormalizationSettings', ], 'AudioSelectorName' => [ 'shape' => '__string', 'locationName' => 'audioSelectorName', ], 'AudioType' => [ 'shape' => 'AudioType', 'locationName' => 'audioType', ], 'AudioTypeControl' => [ 'shape' => 'AudioDescriptionAudioTypeControl', 'locationName' => 'audioTypeControl', ], 'CodecSettings' => [ 'shape' => 'AudioCodecSettings', 'locationName' => 'codecSettings', ], 'LanguageCode' => [ 'shape' => '__string', 'locationName' => 'languageCode', ], 'LanguageCodeControl' => [ 'shape' => 'AudioDescriptionLanguageCodeControl', 'locationName' => 'languageCodeControl', ], 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'RemixSettings' => [ 'shape' => 'RemixSettings', 'locationName' => 'remixSettings', ], 'StreamName' => [ 'shape' => '__string', 'locationName' => 'streamName', ], ], ], 'AudioDescriptionAudioTypeControl' => [ 'type' => 'string', 'enum' => [ 'FOLLOW_INPUT', 'USE_CONFIGURED', ], ], 'AudioDescriptionLanguageCodeControl' => [ 'type' => 'string', 'enum' => [ 'FOLLOW_INPUT', 'USE_CONFIGURED', ], ], 'AudioLanguageSelection' => [ 'type' => 'structure', 'members' => [ 'LanguageCode' => [ 'shape' => '__string', 'locationName' => 'languageCode', ], 'LanguageSelectionPolicy' => [ 'shape' => 'AudioLanguageSelectionPolicy', 'locationName' => 'languageSelectionPolicy', ], ], ], 'AudioLanguageSelectionPolicy' => [ 'type' => 'string', 'enum' => [ 'LOOSE', 'STRICT', ], ], 'AudioNormalizationAlgorithm' => [ 'type' => 'string', 'enum' => [ 'ITU_1770_1', 'ITU_1770_2', ], ], 'AudioNormalizationAlgorithmControl' => [ 'type' => 'string', 'enum' => [ 'CORRECT_AUDIO', ], ], 'AudioNormalizationSettings' => [ 'type' => 'structure', 'members' => [ 'Algorithm' => [ 'shape' => 'AudioNormalizationAlgorithm', 'locationName' => 'algorithm', ], 'AlgorithmControl' => [ 'shape' => 'AudioNormalizationAlgorithmControl', 'locationName' => 'algorithmControl', ], 'TargetLkfs' => [ 'shape' => '__double', 'locationName' => 'targetLkfs', ], ], ], 'AudioOnlyHlsSettings' => [ 'type' => 'structure', 'members' => [ 'AudioGroupId' => [ 'shape' => '__string', 'locationName' => 'audioGroupId', ], 'AudioOnlyImage' => [ 'shape' => 'InputLocation', 'locationName' => 'audioOnlyImage', ], 'AudioTrackType' => [ 'shape' => 'AudioOnlyHlsTrackType', 'locationName' => 'audioTrackType', ], ], ], 'AudioOnlyHlsTrackType' => [ 'type' => 'string', 'enum' => [ 'ALTERNATE_AUDIO_AUTO_SELECT', 'ALTERNATE_AUDIO_AUTO_SELECT_DEFAULT', 'ALTERNATE_AUDIO_NOT_AUTO_SELECT', 'AUDIO_ONLY_VARIANT_STREAM', ], ], 'AudioPidSelection' => [ 'type' => 'structure', 'members' => [ 'Pid' => [ 'shape' => '__integer', 'locationName' => 'pid', ], ], ], 'AudioSelector' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'SelectorSettings' => [ 'shape' => 'AudioSelectorSettings', 'locationName' => 'selectorSettings', ], ], ], 'AudioSelectorSettings' => [ 'type' => 'structure', 'members' => [ 'AudioLanguageSelection' => [ 'shape' => 'AudioLanguageSelection', 'locationName' => 'audioLanguageSelection', ], 'AudioPidSelection' => [ 'shape' => 'AudioPidSelection', 'locationName' => 'audioPidSelection', ], ], ], 'AudioType' => [ 'type' => 'string', 'enum' => [ 'CLEAN_EFFECTS', 'HEARING_IMPAIRED', 'UNDEFINED', 'VISUAL_IMPAIRED_COMMENTARY', ], ], 'AvailBlanking' => [ 'type' => 'structure', 'members' => [ 'AvailBlankingImage' => [ 'shape' => 'InputLocation', 'locationName' => 'availBlankingImage', ], 'State' => [ 'shape' => 'AvailBlankingState', 'locationName' => 'state', ], ], ], 'AvailBlankingState' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', ], ], 'AvailConfiguration' => [ 'type' => 'structure', 'members' => [ 'AvailSettings' => [ 'shape' => 'AvailSettings', 'locationName' => 'availSettings', ], ], ], 'AvailSettings' => [ 'type' => 'structure', 'members' => [ 'Scte35SpliceInsert' => [ 'shape' => 'Scte35SpliceInsert', 'locationName' => 'scte35SpliceInsert', ], 'Scte35TimeSignalApos' => [ 'shape' => 'Scte35TimeSignalApos', 'locationName' => 'scte35TimeSignalApos', ], ], ], 'BadGatewayException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => '__string', 'locationName' => 'message', ], ], 'exception' => true, 'error' => [ 'httpStatusCode' => 502, ], ], 'BadRequestException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => '__string', 'locationName' => 'message', ], ], 'exception' => true, 'error' => [ 'httpStatusCode' => 400, ], ], 'BlackoutSlate' => [ 'type' => 'structure', 'members' => [ 'BlackoutSlateImage' => [ 'shape' => 'InputLocation', 'locationName' => 'blackoutSlateImage', ], 'NetworkEndBlackout' => [ 'shape' => 'BlackoutSlateNetworkEndBlackout', 'locationName' => 'networkEndBlackout', ], 'NetworkEndBlackoutImage' => [ 'shape' => 'InputLocation', 'locationName' => 'networkEndBlackoutImage', ], 'NetworkId' => [ 'shape' => '__string', 'locationName' => 'networkId', ], 'State' => [ 'shape' => 'BlackoutSlateState', 'locationName' => 'state', ], ], ], 'BlackoutSlateNetworkEndBlackout' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', ], ], 'BlackoutSlateState' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', ], ], 'BurnInAlignment' => [ 'type' => 'string', 'enum' => [ 'CENTERED', 'LEFT', 'SMART', ], ], 'BurnInBackgroundColor' => [ 'type' => 'string', 'enum' => [ 'BLACK', 'NONE', 'WHITE', ], ], 'BurnInDestinationSettings' => [ 'type' => 'structure', 'members' => [ 'Alignment' => [ 'shape' => 'BurnInAlignment', 'locationName' => 'alignment', ], 'BackgroundColor' => [ 'shape' => 'BurnInBackgroundColor', 'locationName' => 'backgroundColor', ], 'BackgroundOpacity' => [ 'shape' => '__integer', 'locationName' => 'backgroundOpacity', ], 'Font' => [ 'shape' => 'InputLocation', 'locationName' => 'font', ], 'FontColor' => [ 'shape' => 'BurnInFontColor', 'locationName' => 'fontColor', ], 'FontOpacity' => [ 'shape' => '__integer', 'locationName' => 'fontOpacity', ], 'FontResolution' => [ 'shape' => '__integer', 'locationName' => 'fontResolution', ], 'FontSize' => [ 'shape' => '__string', 'locationName' => 'fontSize', ], 'OutlineColor' => [ 'shape' => 'BurnInOutlineColor', 'locationName' => 'outlineColor', ], 'OutlineSize' => [ 'shape' => '__integer', 'locationName' => 'outlineSize', ], 'ShadowColor' => [ 'shape' => 'BurnInShadowColor', 'locationName' => 'shadowColor', ], 'ShadowOpacity' => [ 'shape' => '__integer', 'locationName' => 'shadowOpacity', ], 'ShadowXOffset' => [ 'shape' => '__integer', 'locationName' => 'shadowXOffset', ], 'ShadowYOffset' => [ 'shape' => '__integer', 'locationName' => 'shadowYOffset', ], 'TeletextGridControl' => [ 'shape' => 'BurnInTeletextGridControl', 'locationName' => 'teletextGridControl', ], 'XPosition' => [ 'shape' => '__integer', 'locationName' => 'xPosition', ], 'YPosition' => [ 'shape' => '__integer', 'locationName' => 'yPosition', ], ], ], 'BurnInFontColor' => [ 'type' => 'string', 'enum' => [ 'BLACK', 'BLUE', 'GREEN', 'RED', 'WHITE', 'YELLOW', ], ], 'BurnInOutlineColor' => [ 'type' => 'string', 'enum' => [ 'BLACK', 'BLUE', 'GREEN', 'RED', 'WHITE', 'YELLOW', ], ], 'BurnInShadowColor' => [ 'type' => 'string', 'enum' => [ 'BLACK', 'NONE', 'WHITE', ], ], 'BurnInTeletextGridControl' => [ 'type' => 'string', 'enum' => [ 'FIXED', 'SCALED', ], ], 'CaptionDescription' => [ 'type' => 'structure', 'members' => [ 'CaptionSelectorName' => [ 'shape' => '__string', 'locationName' => 'captionSelectorName', ], 'DestinationSettings' => [ 'shape' => 'CaptionDestinationSettings', 'locationName' => 'destinationSettings', ], 'LanguageCode' => [ 'shape' => '__string', 'locationName' => 'languageCode', ], 'LanguageDescription' => [ 'shape' => '__string', 'locationName' => 'languageDescription', ], 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], ], ], 'CaptionDestinationSettings' => [ 'type' => 'structure', 'members' => [ 'AribDestinationSettings' => [ 'shape' => 'AribDestinationSettings', 'locationName' => 'aribDestinationSettings', ], 'BurnInDestinationSettings' => [ 'shape' => 'BurnInDestinationSettings', 'locationName' => 'burnInDestinationSettings', ], 'DvbSubDestinationSettings' => [ 'shape' => 'DvbSubDestinationSettings', 'locationName' => 'dvbSubDestinationSettings', ], 'EmbeddedDestinationSettings' => [ 'shape' => 'EmbeddedDestinationSettings', 'locationName' => 'embeddedDestinationSettings', ], 'EmbeddedPlusScte20DestinationSettings' => [ 'shape' => 'EmbeddedPlusScte20DestinationSettings', 'locationName' => 'embeddedPlusScte20DestinationSettings', ], 'Scte20PlusEmbeddedDestinationSettings' => [ 'shape' => 'Scte20PlusEmbeddedDestinationSettings', 'locationName' => 'scte20PlusEmbeddedDestinationSettings', ], 'Scte27DestinationSettings' => [ 'shape' => 'Scte27DestinationSettings', 'locationName' => 'scte27DestinationSettings', ], 'SmpteTtDestinationSettings' => [ 'shape' => 'SmpteTtDestinationSettings', 'locationName' => 'smpteTtDestinationSettings', ], 'TeletextDestinationSettings' => [ 'shape' => 'TeletextDestinationSettings', 'locationName' => 'teletextDestinationSettings', ], 'TtmlDestinationSettings' => [ 'shape' => 'TtmlDestinationSettings', 'locationName' => 'ttmlDestinationSettings', ], 'WebvttDestinationSettings' => [ 'shape' => 'WebvttDestinationSettings', 'locationName' => 'webvttDestinationSettings', ], ], ], 'CaptionLanguageMapping' => [ 'type' => 'structure', 'members' => [ 'CaptionChannel' => [ 'shape' => '__integer', 'locationName' => 'captionChannel', ], 'LanguageCode' => [ 'shape' => '__string', 'locationName' => 'languageCode', ], 'LanguageDescription' => [ 'shape' => '__string', 'locationName' => 'languageDescription', ], ], ], 'CaptionSelector' => [ 'type' => 'structure', 'members' => [ 'LanguageCode' => [ 'shape' => '__string', 'locationName' => 'languageCode', ], 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'SelectorSettings' => [ 'shape' => 'CaptionSelectorSettings', 'locationName' => 'selectorSettings', ], ], ], 'CaptionSelectorSettings' => [ 'type' => 'structure', 'members' => [ 'AribSourceSettings' => [ 'shape' => 'AribSourceSettings', 'locationName' => 'aribSourceSettings', ], 'DvbSubSourceSettings' => [ 'shape' => 'DvbSubSourceSettings', 'locationName' => 'dvbSubSourceSettings', ], 'EmbeddedSourceSettings' => [ 'shape' => 'EmbeddedSourceSettings', 'locationName' => 'embeddedSourceSettings', ], 'Scte20SourceSettings' => [ 'shape' => 'Scte20SourceSettings', 'locationName' => 'scte20SourceSettings', ], 'Scte27SourceSettings' => [ 'shape' => 'Scte27SourceSettings', 'locationName' => 'scte27SourceSettings', ], 'TeletextSourceSettings' => [ 'shape' => 'TeletextSourceSettings', 'locationName' => 'teletextSourceSettings', ], ], ], 'Channel' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'locationName' => 'arn', ], 'Destinations' => [ 'shape' => 'ListOfOutputDestination', 'locationName' => 'destinations', ], 'EgressEndpoints' => [ 'shape' => 'ListOfChannelEgressEndpoint', 'locationName' => 'egressEndpoints', ], 'EncoderSettings' => [ 'shape' => 'EncoderSettings', 'locationName' => 'encoderSettings', ], 'Id' => [ 'shape' => '__string', 'locationName' => 'id', ], 'InputAttachments' => [ 'shape' => 'ListOfInputAttachment', 'locationName' => 'inputAttachments', ], 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'PipelinesRunningCount' => [ 'shape' => '__integer', 'locationName' => 'pipelinesRunningCount', ], 'RoleArn' => [ 'shape' => '__string', 'locationName' => 'roleArn', ], 'State' => [ 'shape' => 'ChannelState', 'locationName' => 'state', ], ], ], 'ChannelConfigurationValidationError' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => '__string', 'locationName' => 'message', ], 'ValidationErrors' => [ 'shape' => 'ListOfValidationError', 'locationName' => 'validationErrors', ], ], ], 'ChannelEgressEndpoint' => [ 'type' => 'structure', 'members' => [ 'SourceIp' => [ 'shape' => '__string', 'locationName' => 'sourceIp', ], ], ], 'ChannelState' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'CREATE_FAILED', 'IDLE', 'STARTING', 'RUNNING', 'RECOVERING', 'STOPPING', 'DELETING', 'DELETED', ], ], 'ChannelSummary' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'locationName' => 'arn', ], 'Destinations' => [ 'shape' => 'ListOfOutputDestination', 'locationName' => 'destinations', ], 'EgressEndpoints' => [ 'shape' => 'ListOfChannelEgressEndpoint', 'locationName' => 'egressEndpoints', ], 'Id' => [ 'shape' => '__string', 'locationName' => 'id', ], 'InputAttachments' => [ 'shape' => 'ListOfInputAttachment', 'locationName' => 'inputAttachments', ], 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'PipelinesRunningCount' => [ 'shape' => '__integer', 'locationName' => 'pipelinesRunningCount', ], 'RoleArn' => [ 'shape' => '__string', 'locationName' => 'roleArn', ], 'State' => [ 'shape' => 'ChannelState', 'locationName' => 'state', ], ], ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => '__string', 'locationName' => 'message', ], ], 'exception' => true, 'error' => [ 'httpStatusCode' => 409, ], ], 'CreateChannel' => [ 'type' => 'structure', 'members' => [ 'Destinations' => [ 'shape' => 'ListOfOutputDestination', 'locationName' => 'destinations', ], 'EncoderSettings' => [ 'shape' => 'EncoderSettings', 'locationName' => 'encoderSettings', ], 'InputAttachments' => [ 'shape' => 'ListOfInputAttachment', 'locationName' => 'inputAttachments', ], 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'RequestId' => [ 'shape' => '__string', 'locationName' => 'requestId', 'idempotencyToken' => true, ], 'Reserved' => [ 'shape' => '__string', 'locationName' => 'reserved', ], 'RoleArn' => [ 'shape' => '__string', 'locationName' => 'roleArn', ], ], ], 'CreateChannelRequest' => [ 'type' => 'structure', 'members' => [ 'Destinations' => [ 'shape' => 'ListOfOutputDestination', 'locationName' => 'destinations', ], 'EncoderSettings' => [ 'shape' => 'EncoderSettings', 'locationName' => 'encoderSettings', ], 'InputAttachments' => [ 'shape' => 'ListOfInputAttachment', 'locationName' => 'inputAttachments', ], 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'RequestId' => [ 'shape' => '__string', 'locationName' => 'requestId', 'idempotencyToken' => true, ], 'Reserved' => [ 'shape' => '__string', 'locationName' => 'reserved', ], 'RoleArn' => [ 'shape' => '__string', 'locationName' => 'roleArn', ], ], ], 'CreateChannelResponse' => [ 'type' => 'structure', 'members' => [ 'Channel' => [ 'shape' => 'Channel', 'locationName' => 'channel', ], ], ], 'CreateChannelResultModel' => [ 'type' => 'structure', 'members' => [ 'Channel' => [ 'shape' => 'Channel', 'locationName' => 'channel', ], ], ], 'CreateInput' => [ 'type' => 'structure', 'members' => [ 'Destinations' => [ 'shape' => 'ListOfInputDestinationRequest', 'locationName' => 'destinations', ], 'InputSecurityGroups' => [ 'shape' => 'ListOf__string', 'locationName' => 'inputSecurityGroups', ], 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'RequestId' => [ 'shape' => '__string', 'locationName' => 'requestId', 'idempotencyToken' => true, ], 'Sources' => [ 'shape' => 'ListOfInputSourceRequest', 'locationName' => 'sources', ], 'Type' => [ 'shape' => 'InputType', 'locationName' => 'type', ], ], ], 'CreateInputRequest' => [ 'type' => 'structure', 'members' => [ 'Destinations' => [ 'shape' => 'ListOfInputDestinationRequest', 'locationName' => 'destinations', ], 'InputSecurityGroups' => [ 'shape' => 'ListOf__string', 'locationName' => 'inputSecurityGroups', ], 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'RequestId' => [ 'shape' => '__string', 'locationName' => 'requestId', 'idempotencyToken' => true, ], 'Sources' => [ 'shape' => 'ListOfInputSourceRequest', 'locationName' => 'sources', ], 'Type' => [ 'shape' => 'InputType', 'locationName' => 'type', ], ], ], 'CreateInputResponse' => [ 'type' => 'structure', 'members' => [ 'Input' => [ 'shape' => 'Input', 'locationName' => 'input', ], ], ], 'CreateInputResultModel' => [ 'type' => 'structure', 'members' => [ 'Input' => [ 'shape' => 'Input', 'locationName' => 'input', ], ], ], 'CreateInputSecurityGroupRequest' => [ 'type' => 'structure', 'members' => [ 'WhitelistRules' => [ 'shape' => 'ListOfInputWhitelistRuleCidr', 'locationName' => 'whitelistRules', ], ], ], 'CreateInputSecurityGroupResponse' => [ 'type' => 'structure', 'members' => [ 'SecurityGroup' => [ 'shape' => 'InputSecurityGroup', 'locationName' => 'securityGroup', ], ], ], 'CreateInputSecurityGroupResultModel' => [ 'type' => 'structure', 'members' => [ 'SecurityGroup' => [ 'shape' => 'InputSecurityGroup', 'locationName' => 'securityGroup', ], ], ], 'DeleteChannelRequest' => [ 'type' => 'structure', 'members' => [ 'ChannelId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'channelId', ], ], 'required' => [ 'ChannelId', ], ], 'DeleteChannelResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'locationName' => 'arn', ], 'Destinations' => [ 'shape' => 'ListOfOutputDestination', 'locationName' => 'destinations', ], 'EgressEndpoints' => [ 'shape' => 'ListOfChannelEgressEndpoint', 'locationName' => 'egressEndpoints', ], 'EncoderSettings' => [ 'shape' => 'EncoderSettings', 'locationName' => 'encoderSettings', ], 'Id' => [ 'shape' => '__string', 'locationName' => 'id', ], 'InputAttachments' => [ 'shape' => 'ListOfInputAttachment', 'locationName' => 'inputAttachments', ], 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'PipelinesRunningCount' => [ 'shape' => '__integer', 'locationName' => 'pipelinesRunningCount', ], 'RoleArn' => [ 'shape' => '__string', 'locationName' => 'roleArn', ], 'State' => [ 'shape' => 'ChannelState', 'locationName' => 'state', ], ], ], 'DeleteInputRequest' => [ 'type' => 'structure', 'members' => [ 'InputId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'inputId', ], ], 'required' => [ 'InputId', ], ], 'DeleteInputResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteInputSecurityGroupRequest' => [ 'type' => 'structure', 'members' => [ 'InputSecurityGroupId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'inputSecurityGroupId', ], ], 'required' => [ 'InputSecurityGroupId', ], ], 'DeleteInputSecurityGroupResponse' => [ 'type' => 'structure', 'members' => [], ], 'DescribeChannelRequest' => [ 'type' => 'structure', 'members' => [ 'ChannelId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'channelId', ], ], 'required' => [ 'ChannelId', ], ], 'DescribeChannelResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'locationName' => 'arn', ], 'Destinations' => [ 'shape' => 'ListOfOutputDestination', 'locationName' => 'destinations', ], 'EgressEndpoints' => [ 'shape' => 'ListOfChannelEgressEndpoint', 'locationName' => 'egressEndpoints', ], 'EncoderSettings' => [ 'shape' => 'EncoderSettings', 'locationName' => 'encoderSettings', ], 'Id' => [ 'shape' => '__string', 'locationName' => 'id', ], 'InputAttachments' => [ 'shape' => 'ListOfInputAttachment', 'locationName' => 'inputAttachments', ], 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'PipelinesRunningCount' => [ 'shape' => '__integer', 'locationName' => 'pipelinesRunningCount', ], 'RoleArn' => [ 'shape' => '__string', 'locationName' => 'roleArn', ], 'State' => [ 'shape' => 'ChannelState', 'locationName' => 'state', ], ], ], 'DescribeInputRequest' => [ 'type' => 'structure', 'members' => [ 'InputId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'inputId', ], ], 'required' => [ 'InputId', ], ], 'DescribeInputResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'locationName' => 'arn', ], 'AttachedChannels' => [ 'shape' => 'ListOf__string', 'locationName' => 'attachedChannels', ], 'Destinations' => [ 'shape' => 'ListOfInputDestination', 'locationName' => 'destinations', ], 'Id' => [ 'shape' => '__string', 'locationName' => 'id', ], 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'SecurityGroups' => [ 'shape' => 'ListOf__string', 'locationName' => 'securityGroups', ], 'Sources' => [ 'shape' => 'ListOfInputSource', 'locationName' => 'sources', ], 'State' => [ 'shape' => 'InputState', 'locationName' => 'state', ], 'Type' => [ 'shape' => 'InputType', 'locationName' => 'type', ], ], ], 'DescribeInputSecurityGroupRequest' => [ 'type' => 'structure', 'members' => [ 'InputSecurityGroupId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'inputSecurityGroupId', ], ], 'required' => [ 'InputSecurityGroupId', ], ], 'DescribeInputSecurityGroupResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'locationName' => 'arn', ], 'Id' => [ 'shape' => '__string', 'locationName' => 'id', ], 'WhitelistRules' => [ 'shape' => 'ListOfInputWhitelistRule', 'locationName' => 'whitelistRules', ], ], ], 'DvbNitSettings' => [ 'type' => 'structure', 'members' => [ 'NetworkId' => [ 'shape' => '__integer', 'locationName' => 'networkId', ], 'NetworkName' => [ 'shape' => '__string', 'locationName' => 'networkName', ], 'RepInterval' => [ 'shape' => '__integer', 'locationName' => 'repInterval', ], ], ], 'DvbSdtOutputSdt' => [ 'type' => 'string', 'enum' => [ 'SDT_FOLLOW', 'SDT_FOLLOW_IF_PRESENT', 'SDT_MANUAL', 'SDT_NONE', ], ], 'DvbSdtSettings' => [ 'type' => 'structure', 'members' => [ 'OutputSdt' => [ 'shape' => 'DvbSdtOutputSdt', 'locationName' => 'outputSdt', ], 'RepInterval' => [ 'shape' => '__integer', 'locationName' => 'repInterval', ], 'ServiceName' => [ 'shape' => '__string', 'locationName' => 'serviceName', ], 'ServiceProviderName' => [ 'shape' => '__string', 'locationName' => 'serviceProviderName', ], ], ], 'DvbSubDestinationAlignment' => [ 'type' => 'string', 'enum' => [ 'CENTERED', 'LEFT', 'SMART', ], ], 'DvbSubDestinationBackgroundColor' => [ 'type' => 'string', 'enum' => [ 'BLACK', 'NONE', 'WHITE', ], ], 'DvbSubDestinationFontColor' => [ 'type' => 'string', 'enum' => [ 'BLACK', 'BLUE', 'GREEN', 'RED', 'WHITE', 'YELLOW', ], ], 'DvbSubDestinationOutlineColor' => [ 'type' => 'string', 'enum' => [ 'BLACK', 'BLUE', 'GREEN', 'RED', 'WHITE', 'YELLOW', ], ], 'DvbSubDestinationSettings' => [ 'type' => 'structure', 'members' => [ 'Alignment' => [ 'shape' => 'DvbSubDestinationAlignment', 'locationName' => 'alignment', ], 'BackgroundColor' => [ 'shape' => 'DvbSubDestinationBackgroundColor', 'locationName' => 'backgroundColor', ], 'BackgroundOpacity' => [ 'shape' => '__integer', 'locationName' => 'backgroundOpacity', ], 'Font' => [ 'shape' => 'InputLocation', 'locationName' => 'font', ], 'FontColor' => [ 'shape' => 'DvbSubDestinationFontColor', 'locationName' => 'fontColor', ], 'FontOpacity' => [ 'shape' => '__integer', 'locationName' => 'fontOpacity', ], 'FontResolution' => [ 'shape' => '__integer', 'locationName' => 'fontResolution', ], 'FontSize' => [ 'shape' => '__string', 'locationName' => 'fontSize', ], 'OutlineColor' => [ 'shape' => 'DvbSubDestinationOutlineColor', 'locationName' => 'outlineColor', ], 'OutlineSize' => [ 'shape' => '__integer', 'locationName' => 'outlineSize', ], 'ShadowColor' => [ 'shape' => 'DvbSubDestinationShadowColor', 'locationName' => 'shadowColor', ], 'ShadowOpacity' => [ 'shape' => '__integer', 'locationName' => 'shadowOpacity', ], 'ShadowXOffset' => [ 'shape' => '__integer', 'locationName' => 'shadowXOffset', ], 'ShadowYOffset' => [ 'shape' => '__integer', 'locationName' => 'shadowYOffset', ], 'TeletextGridControl' => [ 'shape' => 'DvbSubDestinationTeletextGridControl', 'locationName' => 'teletextGridControl', ], 'XPosition' => [ 'shape' => '__integer', 'locationName' => 'xPosition', ], 'YPosition' => [ 'shape' => '__integer', 'locationName' => 'yPosition', ], ], ], 'DvbSubDestinationShadowColor' => [ 'type' => 'string', 'enum' => [ 'BLACK', 'NONE', 'WHITE', ], ], 'DvbSubDestinationTeletextGridControl' => [ 'type' => 'string', 'enum' => [ 'FIXED', 'SCALED', ], ], 'DvbSubSourceSettings' => [ 'type' => 'structure', 'members' => [ 'Pid' => [ 'shape' => '__integer', 'locationName' => 'pid', ], ], ], 'DvbTdtSettings' => [ 'type' => 'structure', 'members' => [ 'RepInterval' => [ 'shape' => '__integer', 'locationName' => 'repInterval', ], ], ], 'Eac3AttenuationControl' => [ 'type' => 'string', 'enum' => [ 'ATTENUATE_3_DB', 'NONE', ], ], 'Eac3BitstreamMode' => [ 'type' => 'string', 'enum' => [ 'COMMENTARY', 'COMPLETE_MAIN', 'EMERGENCY', 'HEARING_IMPAIRED', 'VISUALLY_IMPAIRED', ], ], 'Eac3CodingMode' => [ 'type' => 'string', 'enum' => [ 'CODING_MODE_1_0', 'CODING_MODE_2_0', 'CODING_MODE_3_2', ], ], 'Eac3DcFilter' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', ], ], 'Eac3DrcLine' => [ 'type' => 'string', 'enum' => [ 'FILM_LIGHT', 'FILM_STANDARD', 'MUSIC_LIGHT', 'MUSIC_STANDARD', 'NONE', 'SPEECH', ], ], 'Eac3DrcRf' => [ 'type' => 'string', 'enum' => [ 'FILM_LIGHT', 'FILM_STANDARD', 'MUSIC_LIGHT', 'MUSIC_STANDARD', 'NONE', 'SPEECH', ], ], 'Eac3LfeControl' => [ 'type' => 'string', 'enum' => [ 'LFE', 'NO_LFE', ], ], 'Eac3LfeFilter' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', ], ], 'Eac3MetadataControl' => [ 'type' => 'string', 'enum' => [ 'FOLLOW_INPUT', 'USE_CONFIGURED', ], ], 'Eac3PassthroughControl' => [ 'type' => 'string', 'enum' => [ 'NO_PASSTHROUGH', 'WHEN_POSSIBLE', ], ], 'Eac3PhaseControl' => [ 'type' => 'string', 'enum' => [ 'NO_SHIFT', 'SHIFT_90_DEGREES', ], ], 'Eac3Settings' => [ 'type' => 'structure', 'members' => [ 'AttenuationControl' => [ 'shape' => 'Eac3AttenuationControl', 'locationName' => 'attenuationControl', ], 'Bitrate' => [ 'shape' => '__double', 'locationName' => 'bitrate', ], 'BitstreamMode' => [ 'shape' => 'Eac3BitstreamMode', 'locationName' => 'bitstreamMode', ], 'CodingMode' => [ 'shape' => 'Eac3CodingMode', 'locationName' => 'codingMode', ], 'DcFilter' => [ 'shape' => 'Eac3DcFilter', 'locationName' => 'dcFilter', ], 'Dialnorm' => [ 'shape' => '__integer', 'locationName' => 'dialnorm', ], 'DrcLine' => [ 'shape' => 'Eac3DrcLine', 'locationName' => 'drcLine', ], 'DrcRf' => [ 'shape' => 'Eac3DrcRf', 'locationName' => 'drcRf', ], 'LfeControl' => [ 'shape' => 'Eac3LfeControl', 'locationName' => 'lfeControl', ], 'LfeFilter' => [ 'shape' => 'Eac3LfeFilter', 'locationName' => 'lfeFilter', ], 'LoRoCenterMixLevel' => [ 'shape' => '__double', 'locationName' => 'loRoCenterMixLevel', ], 'LoRoSurroundMixLevel' => [ 'shape' => '__double', 'locationName' => 'loRoSurroundMixLevel', ], 'LtRtCenterMixLevel' => [ 'shape' => '__double', 'locationName' => 'ltRtCenterMixLevel', ], 'LtRtSurroundMixLevel' => [ 'shape' => '__double', 'locationName' => 'ltRtSurroundMixLevel', ], 'MetadataControl' => [ 'shape' => 'Eac3MetadataControl', 'locationName' => 'metadataControl', ], 'PassthroughControl' => [ 'shape' => 'Eac3PassthroughControl', 'locationName' => 'passthroughControl', ], 'PhaseControl' => [ 'shape' => 'Eac3PhaseControl', 'locationName' => 'phaseControl', ], 'StereoDownmix' => [ 'shape' => 'Eac3StereoDownmix', 'locationName' => 'stereoDownmix', ], 'SurroundExMode' => [ 'shape' => 'Eac3SurroundExMode', 'locationName' => 'surroundExMode', ], 'SurroundMode' => [ 'shape' => 'Eac3SurroundMode', 'locationName' => 'surroundMode', ], ], ], 'Eac3StereoDownmix' => [ 'type' => 'string', 'enum' => [ 'DPL2', 'LO_RO', 'LT_RT', 'NOT_INDICATED', ], ], 'Eac3SurroundExMode' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', 'NOT_INDICATED', ], ], 'Eac3SurroundMode' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', 'NOT_INDICATED', ], ], 'EmbeddedConvert608To708' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'UPCONVERT', ], ], 'EmbeddedDestinationSettings' => [ 'type' => 'structure', 'members' => [], ], 'EmbeddedPlusScte20DestinationSettings' => [ 'type' => 'structure', 'members' => [], ], 'EmbeddedScte20Detection' => [ 'type' => 'string', 'enum' => [ 'AUTO', 'OFF', ], ], 'EmbeddedSourceSettings' => [ 'type' => 'structure', 'members' => [ 'Convert608To708' => [ 'shape' => 'EmbeddedConvert608To708', 'locationName' => 'convert608To708', ], 'Scte20Detection' => [ 'shape' => 'EmbeddedScte20Detection', 'locationName' => 'scte20Detection', ], 'Source608ChannelNumber' => [ 'shape' => '__integer', 'locationName' => 'source608ChannelNumber', ], 'Source608TrackNumber' => [ 'shape' => '__integer', 'locationName' => 'source608TrackNumber', ], ], ], 'Empty' => [ 'type' => 'structure', 'members' => [], ], 'EncoderSettings' => [ 'type' => 'structure', 'members' => [ 'AudioDescriptions' => [ 'shape' => 'ListOfAudioDescription', 'locationName' => 'audioDescriptions', ], 'AvailBlanking' => [ 'shape' => 'AvailBlanking', 'locationName' => 'availBlanking', ], 'AvailConfiguration' => [ 'shape' => 'AvailConfiguration', 'locationName' => 'availConfiguration', ], 'BlackoutSlate' => [ 'shape' => 'BlackoutSlate', 'locationName' => 'blackoutSlate', ], 'CaptionDescriptions' => [ 'shape' => 'ListOfCaptionDescription', 'locationName' => 'captionDescriptions', ], 'GlobalConfiguration' => [ 'shape' => 'GlobalConfiguration', 'locationName' => 'globalConfiguration', ], 'OutputGroups' => [ 'shape' => 'ListOfOutputGroup', 'locationName' => 'outputGroups', ], 'TimecodeConfig' => [ 'shape' => 'TimecodeConfig', 'locationName' => 'timecodeConfig', ], 'VideoDescriptions' => [ 'shape' => 'ListOfVideoDescription', 'locationName' => 'videoDescriptions', ], ], ], 'FecOutputIncludeFec' => [ 'type' => 'string', 'enum' => [ 'COLUMN', 'COLUMN_AND_ROW', ], ], 'FecOutputSettings' => [ 'type' => 'structure', 'members' => [ 'ColumnDepth' => [ 'shape' => '__integer', 'locationName' => 'columnDepth', ], 'IncludeFec' => [ 'shape' => 'FecOutputIncludeFec', 'locationName' => 'includeFec', ], 'RowLength' => [ 'shape' => '__integer', 'locationName' => 'rowLength', ], ], ], 'FixedAfd' => [ 'type' => 'string', 'enum' => [ 'AFD_0000', 'AFD_0010', 'AFD_0011', 'AFD_0100', 'AFD_1000', 'AFD_1001', 'AFD_1010', 'AFD_1011', 'AFD_1101', 'AFD_1110', 'AFD_1111', ], ], 'ForbiddenException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => '__string', 'locationName' => 'message', ], ], 'exception' => true, 'error' => [ 'httpStatusCode' => 403, ], ], 'GatewayTimeoutException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => '__string', 'locationName' => 'message', ], ], 'exception' => true, 'error' => [ 'httpStatusCode' => 504, ], ], 'GlobalConfiguration' => [ 'type' => 'structure', 'members' => [ 'InitialAudioGain' => [ 'shape' => '__integer', 'locationName' => 'initialAudioGain', ], 'InputEndAction' => [ 'shape' => 'GlobalConfigurationInputEndAction', 'locationName' => 'inputEndAction', ], 'InputLossBehavior' => [ 'shape' => 'InputLossBehavior', 'locationName' => 'inputLossBehavior', ], 'OutputTimingSource' => [ 'shape' => 'GlobalConfigurationOutputTimingSource', 'locationName' => 'outputTimingSource', ], 'SupportLowFramerateInputs' => [ 'shape' => 'GlobalConfigurationLowFramerateInputs', 'locationName' => 'supportLowFramerateInputs', ], ], ], 'GlobalConfigurationInputEndAction' => [ 'type' => 'string', 'enum' => [ 'NONE', 'SWITCH_AND_LOOP_INPUTS', ], ], 'GlobalConfigurationLowFramerateInputs' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', ], ], 'GlobalConfigurationOutputTimingSource' => [ 'type' => 'string', 'enum' => [ 'INPUT_CLOCK', 'SYSTEM_CLOCK', ], ], 'H264AdaptiveQuantization' => [ 'type' => 'string', 'enum' => [ 'HIGH', 'HIGHER', 'LOW', 'MAX', 'MEDIUM', 'OFF', ], ], 'H264ColorMetadata' => [ 'type' => 'string', 'enum' => [ 'IGNORE', 'INSERT', ], ], 'H264EntropyEncoding' => [ 'type' => 'string', 'enum' => [ 'CABAC', 'CAVLC', ], ], 'H264FlickerAq' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', ], ], 'H264FramerateControl' => [ 'type' => 'string', 'enum' => [ 'INITIALIZE_FROM_SOURCE', 'SPECIFIED', ], ], 'H264GopBReference' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', ], ], 'H264GopSizeUnits' => [ 'type' => 'string', 'enum' => [ 'FRAMES', 'SECONDS', ], ], 'H264Level' => [ 'type' => 'string', 'enum' => [ 'H264_LEVEL_1', 'H264_LEVEL_1_1', 'H264_LEVEL_1_2', 'H264_LEVEL_1_3', 'H264_LEVEL_2', 'H264_LEVEL_2_1', 'H264_LEVEL_2_2', 'H264_LEVEL_3', 'H264_LEVEL_3_1', 'H264_LEVEL_3_2', 'H264_LEVEL_4', 'H264_LEVEL_4_1', 'H264_LEVEL_4_2', 'H264_LEVEL_5', 'H264_LEVEL_5_1', 'H264_LEVEL_5_2', 'H264_LEVEL_AUTO', ], ], 'H264LookAheadRateControl' => [ 'type' => 'string', 'enum' => [ 'HIGH', 'LOW', 'MEDIUM', ], ], 'H264ParControl' => [ 'type' => 'string', 'enum' => [ 'INITIALIZE_FROM_SOURCE', 'SPECIFIED', ], ], 'H264Profile' => [ 'type' => 'string', 'enum' => [ 'BASELINE', 'HIGH', 'HIGH_10BIT', 'HIGH_422', 'HIGH_422_10BIT', 'MAIN', ], ], 'H264RateControlMode' => [ 'type' => 'string', 'enum' => [ 'CBR', 'VBR', ], ], 'H264ScanType' => [ 'type' => 'string', 'enum' => [ 'INTERLACED', 'PROGRESSIVE', ], ], 'H264SceneChangeDetect' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', ], ], 'H264Settings' => [ 'type' => 'structure', 'members' => [ 'AdaptiveQuantization' => [ 'shape' => 'H264AdaptiveQuantization', 'locationName' => 'adaptiveQuantization', ], 'AfdSignaling' => [ 'shape' => 'AfdSignaling', 'locationName' => 'afdSignaling', ], 'Bitrate' => [ 'shape' => '__integer', 'locationName' => 'bitrate', ], 'BufFillPct' => [ 'shape' => '__integer', 'locationName' => 'bufFillPct', ], 'BufSize' => [ 'shape' => '__integer', 'locationName' => 'bufSize', ], 'ColorMetadata' => [ 'shape' => 'H264ColorMetadata', 'locationName' => 'colorMetadata', ], 'EntropyEncoding' => [ 'shape' => 'H264EntropyEncoding', 'locationName' => 'entropyEncoding', ], 'FixedAfd' => [ 'shape' => 'FixedAfd', 'locationName' => 'fixedAfd', ], 'FlickerAq' => [ 'shape' => 'H264FlickerAq', 'locationName' => 'flickerAq', ], 'FramerateControl' => [ 'shape' => 'H264FramerateControl', 'locationName' => 'framerateControl', ], 'FramerateDenominator' => [ 'shape' => '__integer', 'locationName' => 'framerateDenominator', ], 'FramerateNumerator' => [ 'shape' => '__integer', 'locationName' => 'framerateNumerator', ], 'GopBReference' => [ 'shape' => 'H264GopBReference', 'locationName' => 'gopBReference', ], 'GopClosedCadence' => [ 'shape' => '__integer', 'locationName' => 'gopClosedCadence', ], 'GopNumBFrames' => [ 'shape' => '__integer', 'locationName' => 'gopNumBFrames', ], 'GopSize' => [ 'shape' => '__double', 'locationName' => 'gopSize', ], 'GopSizeUnits' => [ 'shape' => 'H264GopSizeUnits', 'locationName' => 'gopSizeUnits', ], 'Level' => [ 'shape' => 'H264Level', 'locationName' => 'level', ], 'LookAheadRateControl' => [ 'shape' => 'H264LookAheadRateControl', 'locationName' => 'lookAheadRateControl', ], 'MaxBitrate' => [ 'shape' => '__integer', 'locationName' => 'maxBitrate', ], 'MinIInterval' => [ 'shape' => '__integer', 'locationName' => 'minIInterval', ], 'NumRefFrames' => [ 'shape' => '__integer', 'locationName' => 'numRefFrames', ], 'ParControl' => [ 'shape' => 'H264ParControl', 'locationName' => 'parControl', ], 'ParDenominator' => [ 'shape' => '__integer', 'locationName' => 'parDenominator', ], 'ParNumerator' => [ 'shape' => '__integer', 'locationName' => 'parNumerator', ], 'Profile' => [ 'shape' => 'H264Profile', 'locationName' => 'profile', ], 'RateControlMode' => [ 'shape' => 'H264RateControlMode', 'locationName' => 'rateControlMode', ], 'ScanType' => [ 'shape' => 'H264ScanType', 'locationName' => 'scanType', ], 'SceneChangeDetect' => [ 'shape' => 'H264SceneChangeDetect', 'locationName' => 'sceneChangeDetect', ], 'Slices' => [ 'shape' => '__integer', 'locationName' => 'slices', ], 'Softness' => [ 'shape' => '__integer', 'locationName' => 'softness', ], 'SpatialAq' => [ 'shape' => 'H264SpatialAq', 'locationName' => 'spatialAq', ], 'Syntax' => [ 'shape' => 'H264Syntax', 'locationName' => 'syntax', ], 'TemporalAq' => [ 'shape' => 'H264TemporalAq', 'locationName' => 'temporalAq', ], 'TimecodeInsertion' => [ 'shape' => 'H264TimecodeInsertionBehavior', 'locationName' => 'timecodeInsertion', ], ], ], 'H264SpatialAq' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', ], ], 'H264Syntax' => [ 'type' => 'string', 'enum' => [ 'DEFAULT', 'RP2027', ], ], 'H264TemporalAq' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', ], ], 'H264TimecodeInsertionBehavior' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'PIC_TIMING_SEI', ], ], 'HlsAdMarkers' => [ 'type' => 'string', 'enum' => [ 'ADOBE', 'ELEMENTAL', 'ELEMENTAL_SCTE35', ], ], 'HlsAkamaiHttpTransferMode' => [ 'type' => 'string', 'enum' => [ 'CHUNKED', 'NON_CHUNKED', ], ], 'HlsAkamaiSettings' => [ 'type' => 'structure', 'members' => [ 'ConnectionRetryInterval' => [ 'shape' => '__integer', 'locationName' => 'connectionRetryInterval', ], 'FilecacheDuration' => [ 'shape' => '__integer', 'locationName' => 'filecacheDuration', ], 'HttpTransferMode' => [ 'shape' => 'HlsAkamaiHttpTransferMode', 'locationName' => 'httpTransferMode', ], 'NumRetries' => [ 'shape' => '__integer', 'locationName' => 'numRetries', ], 'RestartDelay' => [ 'shape' => '__integer', 'locationName' => 'restartDelay', ], 'Salt' => [ 'shape' => '__string', 'locationName' => 'salt', ], 'Token' => [ 'shape' => '__string', 'locationName' => 'token', ], ], ], 'HlsBasicPutSettings' => [ 'type' => 'structure', 'members' => [ 'ConnectionRetryInterval' => [ 'shape' => '__integer', 'locationName' => 'connectionRetryInterval', ], 'FilecacheDuration' => [ 'shape' => '__integer', 'locationName' => 'filecacheDuration', ], 'NumRetries' => [ 'shape' => '__integer', 'locationName' => 'numRetries', ], 'RestartDelay' => [ 'shape' => '__integer', 'locationName' => 'restartDelay', ], ], ], 'HlsCaptionLanguageSetting' => [ 'type' => 'string', 'enum' => [ 'INSERT', 'NONE', 'OMIT', ], ], 'HlsCdnSettings' => [ 'type' => 'structure', 'members' => [ 'HlsAkamaiSettings' => [ 'shape' => 'HlsAkamaiSettings', 'locationName' => 'hlsAkamaiSettings', ], 'HlsBasicPutSettings' => [ 'shape' => 'HlsBasicPutSettings', 'locationName' => 'hlsBasicPutSettings', ], 'HlsMediaStoreSettings' => [ 'shape' => 'HlsMediaStoreSettings', 'locationName' => 'hlsMediaStoreSettings', ], 'HlsWebdavSettings' => [ 'shape' => 'HlsWebdavSettings', 'locationName' => 'hlsWebdavSettings', ], ], ], 'HlsClientCache' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', ], ], 'HlsCodecSpecification' => [ 'type' => 'string', 'enum' => [ 'RFC_4281', 'RFC_6381', ], ], 'HlsDirectoryStructure' => [ 'type' => 'string', 'enum' => [ 'SINGLE_DIRECTORY', 'SUBDIRECTORY_PER_STREAM', ], ], 'HlsEncryptionType' => [ 'type' => 'string', 'enum' => [ 'AES128', 'SAMPLE_AES', ], ], 'HlsGroupSettings' => [ 'type' => 'structure', 'members' => [ 'AdMarkers' => [ 'shape' => 'ListOfHlsAdMarkers', 'locationName' => 'adMarkers', ], 'BaseUrlContent' => [ 'shape' => '__string', 'locationName' => 'baseUrlContent', ], 'BaseUrlManifest' => [ 'shape' => '__string', 'locationName' => 'baseUrlManifest', ], 'CaptionLanguageMappings' => [ 'shape' => 'ListOfCaptionLanguageMapping', 'locationName' => 'captionLanguageMappings', ], 'CaptionLanguageSetting' => [ 'shape' => 'HlsCaptionLanguageSetting', 'locationName' => 'captionLanguageSetting', ], 'ClientCache' => [ 'shape' => 'HlsClientCache', 'locationName' => 'clientCache', ], 'CodecSpecification' => [ 'shape' => 'HlsCodecSpecification', 'locationName' => 'codecSpecification', ], 'ConstantIv' => [ 'shape' => '__string', 'locationName' => 'constantIv', ], 'Destination' => [ 'shape' => 'OutputLocationRef', 'locationName' => 'destination', ], 'DirectoryStructure' => [ 'shape' => 'HlsDirectoryStructure', 'locationName' => 'directoryStructure', ], 'EncryptionType' => [ 'shape' => 'HlsEncryptionType', 'locationName' => 'encryptionType', ], 'HlsCdnSettings' => [ 'shape' => 'HlsCdnSettings', 'locationName' => 'hlsCdnSettings', ], 'IndexNSegments' => [ 'shape' => '__integer', 'locationName' => 'indexNSegments', ], 'InputLossAction' => [ 'shape' => 'InputLossActionForHlsOut', 'locationName' => 'inputLossAction', ], 'IvInManifest' => [ 'shape' => 'HlsIvInManifest', 'locationName' => 'ivInManifest', ], 'IvSource' => [ 'shape' => 'HlsIvSource', 'locationName' => 'ivSource', ], 'KeepSegments' => [ 'shape' => '__integer', 'locationName' => 'keepSegments', ], 'KeyFormat' => [ 'shape' => '__string', 'locationName' => 'keyFormat', ], 'KeyFormatVersions' => [ 'shape' => '__string', 'locationName' => 'keyFormatVersions', ], 'KeyProviderSettings' => [ 'shape' => 'KeyProviderSettings', 'locationName' => 'keyProviderSettings', ], 'ManifestCompression' => [ 'shape' => 'HlsManifestCompression', 'locationName' => 'manifestCompression', ], 'ManifestDurationFormat' => [ 'shape' => 'HlsManifestDurationFormat', 'locationName' => 'manifestDurationFormat', ], 'MinSegmentLength' => [ 'shape' => '__integer', 'locationName' => 'minSegmentLength', ], 'Mode' => [ 'shape' => 'HlsMode', 'locationName' => 'mode', ], 'OutputSelection' => [ 'shape' => 'HlsOutputSelection', 'locationName' => 'outputSelection', ], 'ProgramDateTime' => [ 'shape' => 'HlsProgramDateTime', 'locationName' => 'programDateTime', ], 'ProgramDateTimePeriod' => [ 'shape' => '__integer', 'locationName' => 'programDateTimePeriod', ], 'SegmentLength' => [ 'shape' => '__integer', 'locationName' => 'segmentLength', ], 'SegmentationMode' => [ 'shape' => 'HlsSegmentationMode', 'locationName' => 'segmentationMode', ], 'SegmentsPerSubdirectory' => [ 'shape' => '__integer', 'locationName' => 'segmentsPerSubdirectory', ], 'StreamInfResolution' => [ 'shape' => 'HlsStreamInfResolution', 'locationName' => 'streamInfResolution', ], 'TimedMetadataId3Frame' => [ 'shape' => 'HlsTimedMetadataId3Frame', 'locationName' => 'timedMetadataId3Frame', ], 'TimedMetadataId3Period' => [ 'shape' => '__integer', 'locationName' => 'timedMetadataId3Period', ], 'TimestampDeltaMilliseconds' => [ 'shape' => '__integer', 'locationName' => 'timestampDeltaMilliseconds', ], 'TsFileMode' => [ 'shape' => 'HlsTsFileMode', 'locationName' => 'tsFileMode', ], ], ], 'HlsInputSettings' => [ 'type' => 'structure', 'members' => [ 'Bandwidth' => [ 'shape' => '__integer', 'locationName' => 'bandwidth', ], 'BufferSegments' => [ 'shape' => '__integer', 'locationName' => 'bufferSegments', ], 'Retries' => [ 'shape' => '__integer', 'locationName' => 'retries', ], 'RetryInterval' => [ 'shape' => '__integer', 'locationName' => 'retryInterval', ], ], ], 'HlsIvInManifest' => [ 'type' => 'string', 'enum' => [ 'EXCLUDE', 'INCLUDE', ], ], 'HlsIvSource' => [ 'type' => 'string', 'enum' => [ 'EXPLICIT', 'FOLLOWS_SEGMENT_NUMBER', ], ], 'HlsManifestCompression' => [ 'type' => 'string', 'enum' => [ 'GZIP', 'NONE', ], ], 'HlsManifestDurationFormat' => [ 'type' => 'string', 'enum' => [ 'FLOATING_POINT', 'INTEGER', ], ], 'HlsMediaStoreSettings' => [ 'type' => 'structure', 'members' => [ 'ConnectionRetryInterval' => [ 'shape' => '__integer', 'locationName' => 'connectionRetryInterval', ], 'FilecacheDuration' => [ 'shape' => '__integer', 'locationName' => 'filecacheDuration', ], 'MediaStoreStorageClass' => [ 'shape' => 'HlsMediaStoreStorageClass', 'locationName' => 'mediaStoreStorageClass', ], 'NumRetries' => [ 'shape' => '__integer', 'locationName' => 'numRetries', ], 'RestartDelay' => [ 'shape' => '__integer', 'locationName' => 'restartDelay', ], ], ], 'HlsMediaStoreStorageClass' => [ 'type' => 'string', 'enum' => [ 'TEMPORAL', ], ], 'HlsMode' => [ 'type' => 'string', 'enum' => [ 'LIVE', 'VOD', ], ], 'HlsOutputSelection' => [ 'type' => 'string', 'enum' => [ 'MANIFESTS_AND_SEGMENTS', 'SEGMENTS_ONLY', ], ], 'HlsOutputSettings' => [ 'type' => 'structure', 'members' => [ 'HlsSettings' => [ 'shape' => 'HlsSettings', 'locationName' => 'hlsSettings', ], 'NameModifier' => [ 'shape' => '__string', 'locationName' => 'nameModifier', ], 'SegmentModifier' => [ 'shape' => '__string', 'locationName' => 'segmentModifier', ], ], ], 'HlsProgramDateTime' => [ 'type' => 'string', 'enum' => [ 'EXCLUDE', 'INCLUDE', ], ], 'HlsSegmentationMode' => [ 'type' => 'string', 'enum' => [ 'USE_INPUT_SEGMENTATION', 'USE_SEGMENT_DURATION', ], ], 'HlsSettings' => [ 'type' => 'structure', 'members' => [ 'AudioOnlyHlsSettings' => [ 'shape' => 'AudioOnlyHlsSettings', 'locationName' => 'audioOnlyHlsSettings', ], 'StandardHlsSettings' => [ 'shape' => 'StandardHlsSettings', 'locationName' => 'standardHlsSettings', ], ], ], 'HlsStreamInfResolution' => [ 'type' => 'string', 'enum' => [ 'EXCLUDE', 'INCLUDE', ], ], 'HlsTimedMetadataId3Frame' => [ 'type' => 'string', 'enum' => [ 'NONE', 'PRIV', 'TDRL', ], ], 'HlsTsFileMode' => [ 'type' => 'string', 'enum' => [ 'SEGMENTED_FILES', 'SINGLE_FILE', ], ], 'HlsWebdavHttpTransferMode' => [ 'type' => 'string', 'enum' => [ 'CHUNKED', 'NON_CHUNKED', ], ], 'HlsWebdavSettings' => [ 'type' => 'structure', 'members' => [ 'ConnectionRetryInterval' => [ 'shape' => '__integer', 'locationName' => 'connectionRetryInterval', ], 'FilecacheDuration' => [ 'shape' => '__integer', 'locationName' => 'filecacheDuration', ], 'HttpTransferMode' => [ 'shape' => 'HlsWebdavHttpTransferMode', 'locationName' => 'httpTransferMode', ], 'NumRetries' => [ 'shape' => '__integer', 'locationName' => 'numRetries', ], 'RestartDelay' => [ 'shape' => '__integer', 'locationName' => 'restartDelay', ], ], ], 'Input' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'locationName' => 'arn', ], 'AttachedChannels' => [ 'shape' => 'ListOf__string', 'locationName' => 'attachedChannels', ], 'Destinations' => [ 'shape' => 'ListOfInputDestination', 'locationName' => 'destinations', ], 'Id' => [ 'shape' => '__string', 'locationName' => 'id', ], 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'SecurityGroups' => [ 'shape' => 'ListOf__string', 'locationName' => 'securityGroups', ], 'Sources' => [ 'shape' => 'ListOfInputSource', 'locationName' => 'sources', ], 'State' => [ 'shape' => 'InputState', 'locationName' => 'state', ], 'Type' => [ 'shape' => 'InputType', 'locationName' => 'type', ], ], ], 'InputAttachment' => [ 'type' => 'structure', 'members' => [ 'InputId' => [ 'shape' => '__string', 'locationName' => 'inputId', ], 'InputSettings' => [ 'shape' => 'InputSettings', 'locationName' => 'inputSettings', ], ], ], 'InputChannelLevel' => [ 'type' => 'structure', 'members' => [ 'Gain' => [ 'shape' => '__integer', 'locationName' => 'gain', ], 'InputChannel' => [ 'shape' => '__integer', 'locationName' => 'inputChannel', ], ], ], 'InputDeblockFilter' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', ], ], 'InputDenoiseFilter' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', ], ], 'InputDestination' => [ 'type' => 'structure', 'members' => [ 'Ip' => [ 'shape' => '__string', 'locationName' => 'ip', ], 'Port' => [ 'shape' => '__string', 'locationName' => 'port', ], 'Url' => [ 'shape' => '__string', 'locationName' => 'url', ], ], ], 'InputDestinationRequest' => [ 'type' => 'structure', 'members' => [ 'StreamName' => [ 'shape' => '__string', 'locationName' => 'streamName', ], ], ], 'InputFilter' => [ 'type' => 'string', 'enum' => [ 'AUTO', 'DISABLED', 'FORCED', ], ], 'InputLocation' => [ 'type' => 'structure', 'members' => [ 'PasswordParam' => [ 'shape' => '__string', 'locationName' => 'passwordParam', ], 'Uri' => [ 'shape' => '__string', 'locationName' => 'uri', ], 'Username' => [ 'shape' => '__string', 'locationName' => 'username', ], ], ], 'InputLossActionForHlsOut' => [ 'type' => 'string', 'enum' => [ 'EMIT_OUTPUT', 'PAUSE_OUTPUT', ], ], 'InputLossActionForMsSmoothOut' => [ 'type' => 'string', 'enum' => [ 'EMIT_OUTPUT', 'PAUSE_OUTPUT', ], ], 'InputLossActionForUdpOut' => [ 'type' => 'string', 'enum' => [ 'DROP_PROGRAM', 'DROP_TS', 'EMIT_PROGRAM', ], ], 'InputLossBehavior' => [ 'type' => 'structure', 'members' => [ 'BlackFrameMsec' => [ 'shape' => '__integer', 'locationName' => 'blackFrameMsec', ], 'InputLossImageColor' => [ 'shape' => '__string', 'locationName' => 'inputLossImageColor', ], 'InputLossImageSlate' => [ 'shape' => 'InputLocation', 'locationName' => 'inputLossImageSlate', ], 'InputLossImageType' => [ 'shape' => 'InputLossImageType', 'locationName' => 'inputLossImageType', ], 'RepeatFrameMsec' => [ 'shape' => '__integer', 'locationName' => 'repeatFrameMsec', ], ], ], 'InputLossImageType' => [ 'type' => 'string', 'enum' => [ 'COLOR', 'SLATE', ], ], 'InputSecurityGroup' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'locationName' => 'arn', ], 'Id' => [ 'shape' => '__string', 'locationName' => 'id', ], 'WhitelistRules' => [ 'shape' => 'ListOfInputWhitelistRule', 'locationName' => 'whitelistRules', ], ], ], 'InputSecurityGroupWhitelistRequest' => [ 'type' => 'structure', 'members' => [ 'WhitelistRules' => [ 'shape' => 'ListOfInputWhitelistRuleCidr', 'locationName' => 'whitelistRules', ], ], ], 'InputSettings' => [ 'type' => 'structure', 'members' => [ 'AudioSelectors' => [ 'shape' => 'ListOfAudioSelector', 'locationName' => 'audioSelectors', ], 'CaptionSelectors' => [ 'shape' => 'ListOfCaptionSelector', 'locationName' => 'captionSelectors', ], 'DeblockFilter' => [ 'shape' => 'InputDeblockFilter', 'locationName' => 'deblockFilter', ], 'DenoiseFilter' => [ 'shape' => 'InputDenoiseFilter', 'locationName' => 'denoiseFilter', ], 'FilterStrength' => [ 'shape' => '__integer', 'locationName' => 'filterStrength', ], 'InputFilter' => [ 'shape' => 'InputFilter', 'locationName' => 'inputFilter', ], 'NetworkInputSettings' => [ 'shape' => 'NetworkInputSettings', 'locationName' => 'networkInputSettings', ], 'SourceEndBehavior' => [ 'shape' => 'InputSourceEndBehavior', 'locationName' => 'sourceEndBehavior', ], 'VideoSelector' => [ 'shape' => 'VideoSelector', 'locationName' => 'videoSelector', ], ], ], 'InputSource' => [ 'type' => 'structure', 'members' => [ 'PasswordParam' => [ 'shape' => '__string', 'locationName' => 'passwordParam', ], 'Url' => [ 'shape' => '__string', 'locationName' => 'url', ], 'Username' => [ 'shape' => '__string', 'locationName' => 'username', ], ], ], 'InputSourceEndBehavior' => [ 'type' => 'string', 'enum' => [ 'CONTINUE', 'LOOP', ], ], 'InputSourceRequest' => [ 'type' => 'structure', 'members' => [ 'PasswordParam' => [ 'shape' => '__string', 'locationName' => 'passwordParam', ], 'Url' => [ 'shape' => '__string', 'locationName' => 'url', ], 'Username' => [ 'shape' => '__string', 'locationName' => 'username', ], ], ], 'InputState' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'DETACHED', 'ATTACHED', 'DELETING', 'DELETED', ], ], 'InputType' => [ 'type' => 'string', 'enum' => [ 'UDP_PUSH', 'RTP_PUSH', 'RTMP_PUSH', 'RTMP_PULL', 'URL_PULL', ], ], 'InputWhitelistRule' => [ 'type' => 'structure', 'members' => [ 'Cidr' => [ 'shape' => '__string', 'locationName' => 'cidr', ], ], ], 'InputWhitelistRuleCidr' => [ 'type' => 'structure', 'members' => [ 'Cidr' => [ 'shape' => '__string', 'locationName' => 'cidr', ], ], ], 'InternalServerErrorException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => '__string', 'locationName' => 'message', ], ], 'exception' => true, 'error' => [ 'httpStatusCode' => 500, ], ], 'InternalServiceError' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => '__string', 'locationName' => 'message', ], ], ], 'InvalidRequest' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => '__string', 'locationName' => 'message', ], ], ], 'KeyProviderSettings' => [ 'type' => 'structure', 'members' => [ 'StaticKeySettings' => [ 'shape' => 'StaticKeySettings', 'locationName' => 'staticKeySettings', ], ], ], 'LimitExceeded' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => '__string', 'locationName' => 'message', ], ], ], 'ListChannelsRequest' => [ 'type' => 'structure', 'members' => [ 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'NextToken' => [ 'shape' => '__string', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListChannelsResponse' => [ 'type' => 'structure', 'members' => [ 'Channels' => [ 'shape' => 'ListOfChannelSummary', 'locationName' => 'channels', ], 'NextToken' => [ 'shape' => '__string', 'locationName' => 'nextToken', ], ], ], 'ListChannelsResultModel' => [ 'type' => 'structure', 'members' => [ 'Channels' => [ 'shape' => 'ListOfChannelSummary', 'locationName' => 'channels', ], 'NextToken' => [ 'shape' => '__string', 'locationName' => 'nextToken', ], ], ], 'ListInputSecurityGroupsRequest' => [ 'type' => 'structure', 'members' => [ 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'NextToken' => [ 'shape' => '__string', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListInputSecurityGroupsResponse' => [ 'type' => 'structure', 'members' => [ 'InputSecurityGroups' => [ 'shape' => 'ListOfInputSecurityGroup', 'locationName' => 'inputSecurityGroups', ], 'NextToken' => [ 'shape' => '__string', 'locationName' => 'nextToken', ], ], ], 'ListInputSecurityGroupsResultModel' => [ 'type' => 'structure', 'members' => [ 'InputSecurityGroups' => [ 'shape' => 'ListOfInputSecurityGroup', 'locationName' => 'inputSecurityGroups', ], 'NextToken' => [ 'shape' => '__string', 'locationName' => 'nextToken', ], ], ], 'ListInputsRequest' => [ 'type' => 'structure', 'members' => [ 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'NextToken' => [ 'shape' => '__string', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListInputsResponse' => [ 'type' => 'structure', 'members' => [ 'Inputs' => [ 'shape' => 'ListOfInput', 'locationName' => 'inputs', ], 'NextToken' => [ 'shape' => '__string', 'locationName' => 'nextToken', ], ], ], 'ListInputsResultModel' => [ 'type' => 'structure', 'members' => [ 'Inputs' => [ 'shape' => 'ListOfInput', 'locationName' => 'inputs', ], 'NextToken' => [ 'shape' => '__string', 'locationName' => 'nextToken', ], ], ], 'ListOfAudioChannelMapping' => [ 'type' => 'list', 'member' => [ 'shape' => 'AudioChannelMapping', ], ], 'ListOfAudioDescription' => [ 'type' => 'list', 'member' => [ 'shape' => 'AudioDescription', ], ], 'ListOfAudioSelector' => [ 'type' => 'list', 'member' => [ 'shape' => 'AudioSelector', ], ], 'ListOfCaptionDescription' => [ 'type' => 'list', 'member' => [ 'shape' => 'CaptionDescription', ], ], 'ListOfCaptionLanguageMapping' => [ 'type' => 'list', 'member' => [ 'shape' => 'CaptionLanguageMapping', ], ], 'ListOfCaptionSelector' => [ 'type' => 'list', 'member' => [ 'shape' => 'CaptionSelector', ], ], 'ListOfChannelEgressEndpoint' => [ 'type' => 'list', 'member' => [ 'shape' => 'ChannelEgressEndpoint', ], ], 'ListOfChannelSummary' => [ 'type' => 'list', 'member' => [ 'shape' => 'ChannelSummary', ], ], 'ListOfHlsAdMarkers' => [ 'type' => 'list', 'member' => [ 'shape' => 'HlsAdMarkers', ], ], 'ListOfInput' => [ 'type' => 'list', 'member' => [ 'shape' => 'Input', ], ], 'ListOfInputAttachment' => [ 'type' => 'list', 'member' => [ 'shape' => 'InputAttachment', ], ], 'ListOfInputChannelLevel' => [ 'type' => 'list', 'member' => [ 'shape' => 'InputChannelLevel', ], ], 'ListOfInputDestination' => [ 'type' => 'list', 'member' => [ 'shape' => 'InputDestination', ], ], 'ListOfInputDestinationRequest' => [ 'type' => 'list', 'member' => [ 'shape' => 'InputDestinationRequest', ], ], 'ListOfInputSecurityGroup' => [ 'type' => 'list', 'member' => [ 'shape' => 'InputSecurityGroup', ], ], 'ListOfInputSource' => [ 'type' => 'list', 'member' => [ 'shape' => 'InputSource', ], ], 'ListOfInputSourceRequest' => [ 'type' => 'list', 'member' => [ 'shape' => 'InputSourceRequest', ], ], 'ListOfInputWhitelistRule' => [ 'type' => 'list', 'member' => [ 'shape' => 'InputWhitelistRule', ], ], 'ListOfInputWhitelistRuleCidr' => [ 'type' => 'list', 'member' => [ 'shape' => 'InputWhitelistRuleCidr', ], ], 'ListOfOutput' => [ 'type' => 'list', 'member' => [ 'shape' => 'Output', ], ], 'ListOfOutputDestination' => [ 'type' => 'list', 'member' => [ 'shape' => 'OutputDestination', ], ], 'ListOfOutputDestinationSettings' => [ 'type' => 'list', 'member' => [ 'shape' => 'OutputDestinationSettings', ], ], 'ListOfOutputGroup' => [ 'type' => 'list', 'member' => [ 'shape' => 'OutputGroup', ], ], 'ListOfValidationError' => [ 'type' => 'list', 'member' => [ 'shape' => 'ValidationError', ], ], 'ListOfVideoDescription' => [ 'type' => 'list', 'member' => [ 'shape' => 'VideoDescription', ], ], 'ListOf__string' => [ 'type' => 'list', 'member' => [ 'shape' => '__string', ], ], 'M2tsAbsentInputAudioBehavior' => [ 'type' => 'string', 'enum' => [ 'DROP', 'ENCODE_SILENCE', ], ], 'M2tsArib' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', ], ], 'M2tsAribCaptionsPidControl' => [ 'type' => 'string', 'enum' => [ 'AUTO', 'USE_CONFIGURED', ], ], 'M2tsAudioBufferModel' => [ 'type' => 'string', 'enum' => [ 'ATSC', 'DVB', ], ], 'M2tsAudioInterval' => [ 'type' => 'string', 'enum' => [ 'VIDEO_AND_FIXED_INTERVALS', 'VIDEO_INTERVAL', ], ], 'M2tsAudioStreamType' => [ 'type' => 'string', 'enum' => [ 'ATSC', 'DVB', ], ], 'M2tsBufferModel' => [ 'type' => 'string', 'enum' => [ 'MULTIPLEX', 'NONE', ], ], 'M2tsCcDescriptor' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', ], ], 'M2tsEbifControl' => [ 'type' => 'string', 'enum' => [ 'NONE', 'PASSTHROUGH', ], ], 'M2tsEbpPlacement' => [ 'type' => 'string', 'enum' => [ 'VIDEO_AND_AUDIO_PIDS', 'VIDEO_PID', ], ], 'M2tsEsRateInPes' => [ 'type' => 'string', 'enum' => [ 'EXCLUDE', 'INCLUDE', ], ], 'M2tsKlv' => [ 'type' => 'string', 'enum' => [ 'NONE', 'PASSTHROUGH', ], ], 'M2tsPcrControl' => [ 'type' => 'string', 'enum' => [ 'CONFIGURED_PCR_PERIOD', 'PCR_EVERY_PES_PACKET', ], ], 'M2tsRateMode' => [ 'type' => 'string', 'enum' => [ 'CBR', 'VBR', ], ], 'M2tsScte35Control' => [ 'type' => 'string', 'enum' => [ 'NONE', 'PASSTHROUGH', ], ], 'M2tsSegmentationMarkers' => [ 'type' => 'string', 'enum' => [ 'EBP', 'EBP_LEGACY', 'NONE', 'PSI_SEGSTART', 'RAI_ADAPT', 'RAI_SEGSTART', ], ], 'M2tsSegmentationStyle' => [ 'type' => 'string', 'enum' => [ 'MAINTAIN_CADENCE', 'RESET_CADENCE', ], ], 'M2tsSettings' => [ 'type' => 'structure', 'members' => [ 'AbsentInputAudioBehavior' => [ 'shape' => 'M2tsAbsentInputAudioBehavior', 'locationName' => 'absentInputAudioBehavior', ], 'Arib' => [ 'shape' => 'M2tsArib', 'locationName' => 'arib', ], 'AribCaptionsPid' => [ 'shape' => '__string', 'locationName' => 'aribCaptionsPid', ], 'AribCaptionsPidControl' => [ 'shape' => 'M2tsAribCaptionsPidControl', 'locationName' => 'aribCaptionsPidControl', ], 'AudioBufferModel' => [ 'shape' => 'M2tsAudioBufferModel', 'locationName' => 'audioBufferModel', ], 'AudioFramesPerPes' => [ 'shape' => '__integer', 'locationName' => 'audioFramesPerPes', ], 'AudioPids' => [ 'shape' => '__string', 'locationName' => 'audioPids', ], 'AudioStreamType' => [ 'shape' => 'M2tsAudioStreamType', 'locationName' => 'audioStreamType', ], 'Bitrate' => [ 'shape' => '__integer', 'locationName' => 'bitrate', ], 'BufferModel' => [ 'shape' => 'M2tsBufferModel', 'locationName' => 'bufferModel', ], 'CcDescriptor' => [ 'shape' => 'M2tsCcDescriptor', 'locationName' => 'ccDescriptor', ], 'DvbNitSettings' => [ 'shape' => 'DvbNitSettings', 'locationName' => 'dvbNitSettings', ], 'DvbSdtSettings' => [ 'shape' => 'DvbSdtSettings', 'locationName' => 'dvbSdtSettings', ], 'DvbSubPids' => [ 'shape' => '__string', 'locationName' => 'dvbSubPids', ], 'DvbTdtSettings' => [ 'shape' => 'DvbTdtSettings', 'locationName' => 'dvbTdtSettings', ], 'DvbTeletextPid' => [ 'shape' => '__string', 'locationName' => 'dvbTeletextPid', ], 'Ebif' => [ 'shape' => 'M2tsEbifControl', 'locationName' => 'ebif', ], 'EbpAudioInterval' => [ 'shape' => 'M2tsAudioInterval', 'locationName' => 'ebpAudioInterval', ], 'EbpLookaheadMs' => [ 'shape' => '__integer', 'locationName' => 'ebpLookaheadMs', ], 'EbpPlacement' => [ 'shape' => 'M2tsEbpPlacement', 'locationName' => 'ebpPlacement', ], 'EcmPid' => [ 'shape' => '__string', 'locationName' => 'ecmPid', ], 'EsRateInPes' => [ 'shape' => 'M2tsEsRateInPes', 'locationName' => 'esRateInPes', ], 'EtvPlatformPid' => [ 'shape' => '__string', 'locationName' => 'etvPlatformPid', ], 'EtvSignalPid' => [ 'shape' => '__string', 'locationName' => 'etvSignalPid', ], 'FragmentTime' => [ 'shape' => '__double', 'locationName' => 'fragmentTime', ], 'Klv' => [ 'shape' => 'M2tsKlv', 'locationName' => 'klv', ], 'KlvDataPids' => [ 'shape' => '__string', 'locationName' => 'klvDataPids', ], 'NullPacketBitrate' => [ 'shape' => '__double', 'locationName' => 'nullPacketBitrate', ], 'PatInterval' => [ 'shape' => '__integer', 'locationName' => 'patInterval', ], 'PcrControl' => [ 'shape' => 'M2tsPcrControl', 'locationName' => 'pcrControl', ], 'PcrPeriod' => [ 'shape' => '__integer', 'locationName' => 'pcrPeriod', ], 'PcrPid' => [ 'shape' => '__string', 'locationName' => 'pcrPid', ], 'PmtInterval' => [ 'shape' => '__integer', 'locationName' => 'pmtInterval', ], 'PmtPid' => [ 'shape' => '__string', 'locationName' => 'pmtPid', ], 'ProgramNum' => [ 'shape' => '__integer', 'locationName' => 'programNum', ], 'RateMode' => [ 'shape' => 'M2tsRateMode', 'locationName' => 'rateMode', ], 'Scte27Pids' => [ 'shape' => '__string', 'locationName' => 'scte27Pids', ], 'Scte35Control' => [ 'shape' => 'M2tsScte35Control', 'locationName' => 'scte35Control', ], 'Scte35Pid' => [ 'shape' => '__string', 'locationName' => 'scte35Pid', ], 'SegmentationMarkers' => [ 'shape' => 'M2tsSegmentationMarkers', 'locationName' => 'segmentationMarkers', ], 'SegmentationStyle' => [ 'shape' => 'M2tsSegmentationStyle', 'locationName' => 'segmentationStyle', ], 'SegmentationTime' => [ 'shape' => '__double', 'locationName' => 'segmentationTime', ], 'TimedMetadataBehavior' => [ 'shape' => 'M2tsTimedMetadataBehavior', 'locationName' => 'timedMetadataBehavior', ], 'TimedMetadataPid' => [ 'shape' => '__string', 'locationName' => 'timedMetadataPid', ], 'TransportStreamId' => [ 'shape' => '__integer', 'locationName' => 'transportStreamId', ], 'VideoPid' => [ 'shape' => '__string', 'locationName' => 'videoPid', ], ], ], 'M2tsTimedMetadataBehavior' => [ 'type' => 'string', 'enum' => [ 'NO_PASSTHROUGH', 'PASSTHROUGH', ], ], 'M3u8PcrControl' => [ 'type' => 'string', 'enum' => [ 'CONFIGURED_PCR_PERIOD', 'PCR_EVERY_PES_PACKET', ], ], 'M3u8Scte35Behavior' => [ 'type' => 'string', 'enum' => [ 'NO_PASSTHROUGH', 'PASSTHROUGH', ], ], 'M3u8Settings' => [ 'type' => 'structure', 'members' => [ 'AudioFramesPerPes' => [ 'shape' => '__integer', 'locationName' => 'audioFramesPerPes', ], 'AudioPids' => [ 'shape' => '__string', 'locationName' => 'audioPids', ], 'EcmPid' => [ 'shape' => '__string', 'locationName' => 'ecmPid', ], 'PatInterval' => [ 'shape' => '__integer', 'locationName' => 'patInterval', ], 'PcrControl' => [ 'shape' => 'M3u8PcrControl', 'locationName' => 'pcrControl', ], 'PcrPeriod' => [ 'shape' => '__integer', 'locationName' => 'pcrPeriod', ], 'PcrPid' => [ 'shape' => '__string', 'locationName' => 'pcrPid', ], 'PmtInterval' => [ 'shape' => '__integer', 'locationName' => 'pmtInterval', ], 'PmtPid' => [ 'shape' => '__string', 'locationName' => 'pmtPid', ], 'ProgramNum' => [ 'shape' => '__integer', 'locationName' => 'programNum', ], 'Scte35Behavior' => [ 'shape' => 'M3u8Scte35Behavior', 'locationName' => 'scte35Behavior', ], 'Scte35Pid' => [ 'shape' => '__string', 'locationName' => 'scte35Pid', ], 'TimedMetadataBehavior' => [ 'shape' => 'M3u8TimedMetadataBehavior', 'locationName' => 'timedMetadataBehavior', ], 'TransportStreamId' => [ 'shape' => '__integer', 'locationName' => 'transportStreamId', ], 'VideoPid' => [ 'shape' => '__string', 'locationName' => 'videoPid', ], ], ], 'M3u8TimedMetadataBehavior' => [ 'type' => 'string', 'enum' => [ 'NO_PASSTHROUGH', 'PASSTHROUGH', ], ], 'MaxResults' => [ 'type' => 'integer', 'min' => 1, 'max' => 1000, ], 'Mp2CodingMode' => [ 'type' => 'string', 'enum' => [ 'CODING_MODE_1_0', 'CODING_MODE_2_0', ], ], 'Mp2Settings' => [ 'type' => 'structure', 'members' => [ 'Bitrate' => [ 'shape' => '__double', 'locationName' => 'bitrate', ], 'CodingMode' => [ 'shape' => 'Mp2CodingMode', 'locationName' => 'codingMode', ], 'SampleRate' => [ 'shape' => '__double', 'locationName' => 'sampleRate', ], ], ], 'MsSmoothGroupSettings' => [ 'type' => 'structure', 'members' => [ 'AcquisitionPointId' => [ 'shape' => '__string', 'locationName' => 'acquisitionPointId', ], 'AudioOnlyTimecodeControl' => [ 'shape' => 'SmoothGroupAudioOnlyTimecodeControl', 'locationName' => 'audioOnlyTimecodeControl', ], 'CertificateMode' => [ 'shape' => 'SmoothGroupCertificateMode', 'locationName' => 'certificateMode', ], 'ConnectionRetryInterval' => [ 'shape' => '__integer', 'locationName' => 'connectionRetryInterval', ], 'Destination' => [ 'shape' => 'OutputLocationRef', 'locationName' => 'destination', ], 'EventId' => [ 'shape' => '__string', 'locationName' => 'eventId', ], 'EventIdMode' => [ 'shape' => 'SmoothGroupEventIdMode', 'locationName' => 'eventIdMode', ], 'EventStopBehavior' => [ 'shape' => 'SmoothGroupEventStopBehavior', 'locationName' => 'eventStopBehavior', ], 'FilecacheDuration' => [ 'shape' => '__integer', 'locationName' => 'filecacheDuration', ], 'FragmentLength' => [ 'shape' => '__integer', 'locationName' => 'fragmentLength', ], 'InputLossAction' => [ 'shape' => 'InputLossActionForMsSmoothOut', 'locationName' => 'inputLossAction', ], 'NumRetries' => [ 'shape' => '__integer', 'locationName' => 'numRetries', ], 'RestartDelay' => [ 'shape' => '__integer', 'locationName' => 'restartDelay', ], 'SegmentationMode' => [ 'shape' => 'SmoothGroupSegmentationMode', 'locationName' => 'segmentationMode', ], 'SendDelayMs' => [ 'shape' => '__integer', 'locationName' => 'sendDelayMs', ], 'SparseTrackType' => [ 'shape' => 'SmoothGroupSparseTrackType', 'locationName' => 'sparseTrackType', ], 'StreamManifestBehavior' => [ 'shape' => 'SmoothGroupStreamManifestBehavior', 'locationName' => 'streamManifestBehavior', ], 'TimestampOffset' => [ 'shape' => '__string', 'locationName' => 'timestampOffset', ], 'TimestampOffsetMode' => [ 'shape' => 'SmoothGroupTimestampOffsetMode', 'locationName' => 'timestampOffsetMode', ], ], ], 'MsSmoothOutputSettings' => [ 'type' => 'structure', 'members' => [ 'NameModifier' => [ 'shape' => '__string', 'locationName' => 'nameModifier', ], ], ], 'NetworkInputServerValidation' => [ 'type' => 'string', 'enum' => [ 'CHECK_CRYPTOGRAPHY_AND_VALIDATE_NAME', 'CHECK_CRYPTOGRAPHY_ONLY', ], ], 'NetworkInputSettings' => [ 'type' => 'structure', 'members' => [ 'HlsInputSettings' => [ 'shape' => 'HlsInputSettings', 'locationName' => 'hlsInputSettings', ], 'ServerValidation' => [ 'shape' => 'NetworkInputServerValidation', 'locationName' => 'serverValidation', ], ], ], 'NotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => '__string', 'locationName' => 'message', ], ], 'exception' => true, 'error' => [ 'httpStatusCode' => 404, ], ], 'Output' => [ 'type' => 'structure', 'members' => [ 'AudioDescriptionNames' => [ 'shape' => 'ListOf__string', 'locationName' => 'audioDescriptionNames', ], 'CaptionDescriptionNames' => [ 'shape' => 'ListOf__string', 'locationName' => 'captionDescriptionNames', ], 'OutputName' => [ 'shape' => '__string', 'locationName' => 'outputName', ], 'OutputSettings' => [ 'shape' => 'OutputSettings', 'locationName' => 'outputSettings', ], 'VideoDescriptionName' => [ 'shape' => '__string', 'locationName' => 'videoDescriptionName', ], ], ], 'OutputDestination' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => '__string', 'locationName' => 'id', ], 'Settings' => [ 'shape' => 'ListOfOutputDestinationSettings', 'locationName' => 'settings', ], ], ], 'OutputDestinationSettings' => [ 'type' => 'structure', 'members' => [ 'PasswordParam' => [ 'shape' => '__string', 'locationName' => 'passwordParam', ], 'Url' => [ 'shape' => '__string', 'locationName' => 'url', ], 'Username' => [ 'shape' => '__string', 'locationName' => 'username', ], ], ], 'OutputGroup' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'OutputGroupSettings' => [ 'shape' => 'OutputGroupSettings', 'locationName' => 'outputGroupSettings', ], 'Outputs' => [ 'shape' => 'ListOfOutput', 'locationName' => 'outputs', ], ], ], 'OutputGroupSettings' => [ 'type' => 'structure', 'members' => [ 'ArchiveGroupSettings' => [ 'shape' => 'ArchiveGroupSettings', 'locationName' => 'archiveGroupSettings', ], 'HlsGroupSettings' => [ 'shape' => 'HlsGroupSettings', 'locationName' => 'hlsGroupSettings', ], 'MsSmoothGroupSettings' => [ 'shape' => 'MsSmoothGroupSettings', 'locationName' => 'msSmoothGroupSettings', ], 'UdpGroupSettings' => [ 'shape' => 'UdpGroupSettings', 'locationName' => 'udpGroupSettings', ], ], ], 'OutputLocationRef' => [ 'type' => 'structure', 'members' => [ 'DestinationRefId' => [ 'shape' => '__string', 'locationName' => 'destinationRefId', ], ], ], 'OutputSettings' => [ 'type' => 'structure', 'members' => [ 'ArchiveOutputSettings' => [ 'shape' => 'ArchiveOutputSettings', 'locationName' => 'archiveOutputSettings', ], 'HlsOutputSettings' => [ 'shape' => 'HlsOutputSettings', 'locationName' => 'hlsOutputSettings', ], 'MsSmoothOutputSettings' => [ 'shape' => 'MsSmoothOutputSettings', 'locationName' => 'msSmoothOutputSettings', ], 'UdpOutputSettings' => [ 'shape' => 'UdpOutputSettings', 'locationName' => 'udpOutputSettings', ], ], ], 'PassThroughSettings' => [ 'type' => 'structure', 'members' => [], ], 'RemixSettings' => [ 'type' => 'structure', 'members' => [ 'ChannelMappings' => [ 'shape' => 'ListOfAudioChannelMapping', 'locationName' => 'channelMappings', ], 'ChannelsIn' => [ 'shape' => '__integer', 'locationName' => 'channelsIn', ], 'ChannelsOut' => [ 'shape' => '__integer', 'locationName' => 'channelsOut', ], ], ], 'ResourceConflict' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => '__string', 'locationName' => 'message', ], ], ], 'ResourceNotFound' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => '__string', 'locationName' => 'message', ], ], ], 'Scte20Convert608To708' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'UPCONVERT', ], ], 'Scte20PlusEmbeddedDestinationSettings' => [ 'type' => 'structure', 'members' => [], ], 'Scte20SourceSettings' => [ 'type' => 'structure', 'members' => [ 'Convert608To708' => [ 'shape' => 'Scte20Convert608To708', 'locationName' => 'convert608To708', ], 'Source608ChannelNumber' => [ 'shape' => '__integer', 'locationName' => 'source608ChannelNumber', ], ], ], 'Scte27DestinationSettings' => [ 'type' => 'structure', 'members' => [], ], 'Scte27SourceSettings' => [ 'type' => 'structure', 'members' => [ 'Pid' => [ 'shape' => '__integer', 'locationName' => 'pid', ], ], ], 'Scte35AposNoRegionalBlackoutBehavior' => [ 'type' => 'string', 'enum' => [ 'FOLLOW', 'IGNORE', ], ], 'Scte35AposWebDeliveryAllowedBehavior' => [ 'type' => 'string', 'enum' => [ 'FOLLOW', 'IGNORE', ], ], 'Scte35SpliceInsert' => [ 'type' => 'structure', 'members' => [ 'AdAvailOffset' => [ 'shape' => '__integer', 'locationName' => 'adAvailOffset', ], 'NoRegionalBlackoutFlag' => [ 'shape' => 'Scte35SpliceInsertNoRegionalBlackoutBehavior', 'locationName' => 'noRegionalBlackoutFlag', ], 'WebDeliveryAllowedFlag' => [ 'shape' => 'Scte35SpliceInsertWebDeliveryAllowedBehavior', 'locationName' => 'webDeliveryAllowedFlag', ], ], ], 'Scte35SpliceInsertNoRegionalBlackoutBehavior' => [ 'type' => 'string', 'enum' => [ 'FOLLOW', 'IGNORE', ], ], 'Scte35SpliceInsertWebDeliveryAllowedBehavior' => [ 'type' => 'string', 'enum' => [ 'FOLLOW', 'IGNORE', ], ], 'Scte35TimeSignalApos' => [ 'type' => 'structure', 'members' => [ 'AdAvailOffset' => [ 'shape' => '__integer', 'locationName' => 'adAvailOffset', ], 'NoRegionalBlackoutFlag' => [ 'shape' => 'Scte35AposNoRegionalBlackoutBehavior', 'locationName' => 'noRegionalBlackoutFlag', ], 'WebDeliveryAllowedFlag' => [ 'shape' => 'Scte35AposWebDeliveryAllowedBehavior', 'locationName' => 'webDeliveryAllowedFlag', ], ], ], 'SmoothGroupAudioOnlyTimecodeControl' => [ 'type' => 'string', 'enum' => [ 'PASSTHROUGH', 'USE_CONFIGURED_CLOCK', ], ], 'SmoothGroupCertificateMode' => [ 'type' => 'string', 'enum' => [ 'SELF_SIGNED', 'VERIFY_AUTHENTICITY', ], ], 'SmoothGroupEventIdMode' => [ 'type' => 'string', 'enum' => [ 'NO_EVENT_ID', 'USE_CONFIGURED', 'USE_TIMESTAMP', ], ], 'SmoothGroupEventStopBehavior' => [ 'type' => 'string', 'enum' => [ 'NONE', 'SEND_EOS', ], ], 'SmoothGroupSegmentationMode' => [ 'type' => 'string', 'enum' => [ 'USE_INPUT_SEGMENTATION', 'USE_SEGMENT_DURATION', ], ], 'SmoothGroupSparseTrackType' => [ 'type' => 'string', 'enum' => [ 'NONE', 'SCTE_35', ], ], 'SmoothGroupStreamManifestBehavior' => [ 'type' => 'string', 'enum' => [ 'DO_NOT_SEND', 'SEND', ], ], 'SmoothGroupTimestampOffsetMode' => [ 'type' => 'string', 'enum' => [ 'USE_CONFIGURED_OFFSET', 'USE_EVENT_START_DATE', ], ], 'SmpteTtDestinationSettings' => [ 'type' => 'structure', 'members' => [], ], 'StandardHlsSettings' => [ 'type' => 'structure', 'members' => [ 'AudioRenditionSets' => [ 'shape' => '__string', 'locationName' => 'audioRenditionSets', ], 'M3u8Settings' => [ 'shape' => 'M3u8Settings', 'locationName' => 'm3u8Settings', ], ], ], 'StartChannelRequest' => [ 'type' => 'structure', 'members' => [ 'ChannelId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'channelId', ], ], 'required' => [ 'ChannelId', ], ], 'StartChannelResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'locationName' => 'arn', ], 'Destinations' => [ 'shape' => 'ListOfOutputDestination', 'locationName' => 'destinations', ], 'EgressEndpoints' => [ 'shape' => 'ListOfChannelEgressEndpoint', 'locationName' => 'egressEndpoints', ], 'EncoderSettings' => [ 'shape' => 'EncoderSettings', 'locationName' => 'encoderSettings', ], 'Id' => [ 'shape' => '__string', 'locationName' => 'id', ], 'InputAttachments' => [ 'shape' => 'ListOfInputAttachment', 'locationName' => 'inputAttachments', ], 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'PipelinesRunningCount' => [ 'shape' => '__integer', 'locationName' => 'pipelinesRunningCount', ], 'RoleArn' => [ 'shape' => '__string', 'locationName' => 'roleArn', ], 'State' => [ 'shape' => 'ChannelState', 'locationName' => 'state', ], ], ], 'StaticKeySettings' => [ 'type' => 'structure', 'members' => [ 'KeyProviderServer' => [ 'shape' => 'InputLocation', 'locationName' => 'keyProviderServer', ], 'StaticKeyValue' => [ 'shape' => '__string', 'locationName' => 'staticKeyValue', ], ], ], 'StopChannelRequest' => [ 'type' => 'structure', 'members' => [ 'ChannelId' => [ 'shape' => '__string', 'location' => 'uri', 'locationName' => 'channelId', ], ], 'required' => [ 'ChannelId', ], ], 'StopChannelResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => '__string', 'locationName' => 'arn', ], 'Destinations' => [ 'shape' => 'ListOfOutputDestination', 'locationName' => 'destinations', ], 'EgressEndpoints' => [ 'shape' => 'ListOfChannelEgressEndpoint', 'locationName' => 'egressEndpoints', ], 'EncoderSettings' => [ 'shape' => 'EncoderSettings', 'locationName' => 'encoderSettings', ], 'Id' => [ 'shape' => '__string', 'locationName' => 'id', ], 'InputAttachments' => [ 'shape' => 'ListOfInputAttachment', 'locationName' => 'inputAttachments', ], 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'PipelinesRunningCount' => [ 'shape' => '__integer', 'locationName' => 'pipelinesRunningCount', ], 'RoleArn' => [ 'shape' => '__string', 'locationName' => 'roleArn', ], 'State' => [ 'shape' => 'ChannelState', 'locationName' => 'state', ], ], ], 'TeletextDestinationSettings' => [ 'type' => 'structure', 'members' => [], ], 'TeletextSourceSettings' => [ 'type' => 'structure', 'members' => [ 'PageNumber' => [ 'shape' => '__string', 'locationName' => 'pageNumber', ], ], ], 'TimecodeConfig' => [ 'type' => 'structure', 'members' => [ 'Source' => [ 'shape' => 'TimecodeConfigSource', 'locationName' => 'source', ], 'SyncThreshold' => [ 'shape' => '__integer', 'locationName' => 'syncThreshold', ], ], ], 'TimecodeConfigSource' => [ 'type' => 'string', 'enum' => [ 'EMBEDDED', 'SYSTEMCLOCK', 'ZEROBASED', ], ], 'TooManyRequestsException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => '__string', 'locationName' => 'message', ], ], 'exception' => true, 'error' => [ 'httpStatusCode' => 429, ], ], 'TtmlDestinationSettings' => [ 'type' => 'structure', 'members' => [ 'StyleControl' => [ 'shape' => 'TtmlDestinationStyleControl', 'locationName' => 'styleControl', ], ], ], 'TtmlDestinationStyleControl' => [ 'type' => 'string', 'enum' => [ 'PASSTHROUGH', 'USE_CONFIGURED', ], ], 'UdpContainerSettings' => [ 'type' => 'structure', 'members' => [ 'M2tsSettings' => [ 'shape' => 'M2tsSettings', 'locationName' => 'm2tsSettings', ], ], ], 'UdpGroupSettings' => [ 'type' => 'structure', 'members' => [ 'InputLossAction' => [ 'shape' => 'InputLossActionForUdpOut', 'locationName' => 'inputLossAction', ], 'TimedMetadataId3Frame' => [ 'shape' => 'UdpTimedMetadataId3Frame', 'locationName' => 'timedMetadataId3Frame', ], 'TimedMetadataId3Period' => [ 'shape' => '__integer', 'locationName' => 'timedMetadataId3Period', ], ], ], 'UdpOutputSettings' => [ 'type' => 'structure', 'members' => [ 'BufferMsec' => [ 'shape' => '__integer', 'locationName' => 'bufferMsec', ], 'ContainerSettings' => [ 'shape' => 'UdpContainerSettings', 'locationName' => 'containerSettings', ], 'Destination' => [ 'shape' => 'OutputLocationRef', 'locationName' => 'destination', ], 'FecOutputSettings' => [ 'shape' => 'FecOutputSettings', 'locationName' => 'fecOutputSettings', ], ], ], 'UdpTimedMetadataId3Frame' => [ 'type' => 'string', 'enum' => [ 'NONE', 'PRIV', 'TDRL', ], ], 'UnprocessableEntityException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => '__string', 'locationName' => 'message', ], 'ValidationErrors' => [ 'shape' => 'ListOfValidationError', 'locationName' => 'validationErrors', ], ], 'exception' => true, 'error' => [ 'httpStatusCode' => 422, ], ], 'ValidationError' => [ 'type' => 'structure', 'members' => [ 'ElementPath' => [ 'shape' => '__string', 'locationName' => 'elementPath', ], 'ErrorMessage' => [ 'shape' => '__string', 'locationName' => 'errorMessage', ], ], ], 'VideoCodecSettings' => [ 'type' => 'structure', 'members' => [ 'H264Settings' => [ 'shape' => 'H264Settings', 'locationName' => 'h264Settings', ], ], ], 'VideoDescription' => [ 'type' => 'structure', 'members' => [ 'CodecSettings' => [ 'shape' => 'VideoCodecSettings', 'locationName' => 'codecSettings', ], 'Height' => [ 'shape' => '__integer', 'locationName' => 'height', ], 'Name' => [ 'shape' => '__string', 'locationName' => 'name', ], 'RespondToAfd' => [ 'shape' => 'VideoDescriptionRespondToAfd', 'locationName' => 'respondToAfd', ], 'ScalingBehavior' => [ 'shape' => 'VideoDescriptionScalingBehavior', 'locationName' => 'scalingBehavior', ], 'Sharpness' => [ 'shape' => '__integer', 'locationName' => 'sharpness', ], 'Width' => [ 'shape' => '__integer', 'locationName' => 'width', ], ], ], 'VideoDescriptionRespondToAfd' => [ 'type' => 'string', 'enum' => [ 'NONE', 'PASSTHROUGH', 'RESPOND', ], ], 'VideoDescriptionScalingBehavior' => [ 'type' => 'string', 'enum' => [ 'DEFAULT', 'STRETCH_TO_OUTPUT', ], ], 'VideoSelector' => [ 'type' => 'structure', 'members' => [ 'ColorSpace' => [ 'shape' => 'VideoSelectorColorSpace', 'locationName' => 'colorSpace', ], 'ColorSpaceUsage' => [ 'shape' => 'VideoSelectorColorSpaceUsage', 'locationName' => 'colorSpaceUsage', ], 'SelectorSettings' => [ 'shape' => 'VideoSelectorSettings', 'locationName' => 'selectorSettings', ], ], ], 'VideoSelectorColorSpace' => [ 'type' => 'string', 'enum' => [ 'FOLLOW', 'REC_601', 'REC_709', ], ], 'VideoSelectorColorSpaceUsage' => [ 'type' => 'string', 'enum' => [ 'FALLBACK', 'FORCE', ], ], 'VideoSelectorPid' => [ 'type' => 'structure', 'members' => [ 'Pid' => [ 'shape' => '__integer', 'locationName' => 'pid', ], ], ], 'VideoSelectorProgramId' => [ 'type' => 'structure', 'members' => [ 'ProgramId' => [ 'shape' => '__integer', 'locationName' => 'programId', ], ], ], 'VideoSelectorSettings' => [ 'type' => 'structure', 'members' => [ 'VideoSelectorPid' => [ 'shape' => 'VideoSelectorPid', 'locationName' => 'videoSelectorPid', ], 'VideoSelectorProgramId' => [ 'shape' => 'VideoSelectorProgramId', 'locationName' => 'videoSelectorProgramId', ], ], ], 'WebvttDestinationSettings' => [ 'type' => 'structure', 'members' => [], ], '__boolean' => [ 'type' => 'boolean', ], '__double' => [ 'type' => 'double', ], '__integer' => [ 'type' => 'integer', ], '__string' => [ 'type' => 'string', ], '__timestamp' => [ 'type' => 'timestamp', ], ],];
